"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ViewLocationMonitors = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _reactRouterDom = require("react-router-dom");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/settings/private_locations/view_location_monitors.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ViewLocationMonitors = ({
  count,
  locationName
}) => {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const onButtonClick = () => setIsPopoverOpen(prevState => !prevState);
  const closePopover = () => setIsPopoverOpen(false);
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "syntheticsViewLocationMonitorsButton",
    onClick: onButtonClick,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 28,
      columnNumber: 5
    }
  }, count);
  const history = (0, _reactRouterDom.useHistory)();
  const {
    formattedLocationName,
    href,
    viewMonitorsMessage
  } = (0, _react.useMemo)(() => ({
    formattedLocationName: /*#__PURE__*/_react.default.createElement("strong", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 37,
        columnNumber: 30
      }
    }, locationName),
    href: count > 0 ? history.createHref({
      pathname: '/monitors',
      search: `?locations=${JSON.stringify([locationName])}`
    }) : history.createHref({
      pathname: '/add-monitor'
    }),
    viewMonitorsMessage: count > 0 ? VIEW_LOCATION_MONITORS : CREATE_MONITOR
  }), [count, history, locationName]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: button,
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 5
    }
  }, count > 0 ? /*#__PURE__*/_react.default.createElement(GreaterThanZeroMessage, {
    count: count,
    name: formattedLocationName,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 9
    }
  }) : /*#__PURE__*/_react.default.createElement(ZeroMessage, {
    name: formattedLocationName,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(ViewLocationMonitorsButton, {
    href: href,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 7
    }
  }, viewMonitorsMessage));
};
exports.ViewLocationMonitors = ViewLocationMonitors;
const ViewLocationMonitorsButton = ({
  href,
  children
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "syntheticsViewLocationMonitorsButton",
    href: href,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 5
    }
  }, children);
};
const VIEW_LOCATION_MONITORS = _i18n.i18n.translate('xpack.synthetics.monitorManagement.viewLocationMonitors', {
  defaultMessage: 'View monitors'
});
const CREATE_MONITOR = _i18n.i18n.translate('xpack.synthetics.monitorManagement.createLocationMonitors', {
  defaultMessage: 'Create monitor'
});
const GreaterThanZeroMessage = ({
  count,
  name
}) => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.synthetics.monitorManagement.viewMonitors",
  defaultMessage: "{name} is used in {count, number} {count, plural,one {monitor} other {monitors}}.",
  values: {
    count,
    name
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 89,
    columnNumber: 3
  }
});
const ZeroMessage = ({
  name
}) => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.synthetics.monitorManagement.viewZeroMonitors",
  defaultMessage: "{name} isn't used in any monitors yet.",
  values: {
    name
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 97,
    columnNumber: 3
  }
});