"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricItemExtra = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _formatting = require("../../../../../utils/formatting");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/monitors_page/overview/overview/metric_item/metric_item_extra.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const MetricItemExtra = ({
  stats
}) => {
  const {
    avgDuration,
    minDuration,
    maxDuration
  } = stats;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "xs",
    justifyContent: "flexEnd"
    // empty title to prevent default title from showing
    ,
    title: "",
    component: "span",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 25,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    component: "span",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 33,
      columnNumber: 7
    }
  }, _i18n.i18n.translate('xpack.synthetics.overview.duration.label', {
    defaultMessage: 'Duration'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    component: "span",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 7
    }
  }, avgDuration && minDuration && maxDuration ? /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    title: _i18n.i18n.translate('xpack.synthetics.overview.duration.description', {
      defaultMessage: 'Median duration of last 50 checks'
    }),
    content: _i18n.i18n.translate('xpack.synthetics.overview.duration.description.values', {
      defaultMessage: 'Avg: {avg}, Min: {min}, Max: {max}',
      values: {
        avg: (0, _formatting.formatDuration)(avgDuration, {
          noSpace: true
        }),
        min: (0, _formatting.formatDuration)(minDuration, {
          noSpace: true
        }),
        max: (0, _formatting.formatDuration)(maxDuration, {
          noSpace: true
        })
      }
    }),
    position: "top",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 11
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    title: _i18n.i18n.translate('xpack.synthetics.overview.metricsTooltip.noMetrics.title', {
      defaultMessage: 'Metric data is not available'
    }),
    content: _i18n.i18n.translate('xpack.synthetics.overview.metricsTooltip.noMetrics.content', {
      defaultMessage: 'No metric data available for this monitor'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 11
    }
  })));
};
exports.MetricItemExtra = MetricItemExtra;