"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useMonitorsTableColumns = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _reactRouterDom = require("react-router-dom");
var _public = require("@kbn/observability-shared-plugin/public");
var _reactRedux = require("react-redux");
var _i18n = require("@kbn/i18n");
var _public2 = require("@kbn/kibana-react-plugin/public");
var _monitor_status_col = require("../components/monitor_status_col");
var _state = require("../../../../../../state");
var _monitor_bar_series = require("../components/monitor_bar_series");
var _use_monitor_histogram = require("../../../../hooks/use_monitor_histogram");
var _monitor_type_badge = require("../../../../../common/components/monitor_type_badge");
var _labels = require("../../../../management/monitor_list_table/labels");
var _monitors_actions = require("../components/monitors_actions");
var _labels2 = require("../labels");
var _monitors_duration = require("../components/monitors_duration");
var _use_kibana_space = require("../../../../../../../../hooks/use_kibana_space");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/monitors_page/overview/overview/compact_view/hooks/use_monitors_table_columns.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const useMonitorsTableColumns = ({
  setFlyoutConfigCallback,
  items
}) => {
  const history = (0, _reactRouterDom.useHistory)();
  const {
    histogramsById,
    minInterval
  } = (0, _use_monitor_histogram.useMonitorHistogram)({
    items
  });
  const {
    space
  } = (0, _use_kibana_space.useKibanaSpace)();
  const {
    spaces
  } = (0, _public2.useKibana)().services;
  const {
    pageState: {
      showFromAllSpaces
    }
  } = (0, _reactRedux.useSelector)(_state.selectOverviewState);
  const onClickMonitorFilter = (0, _react.useCallback)((filterName, filterValue) => {
    const searchParams = new URLSearchParams(history.location.search); // Get existing query params
    searchParams.set(filterName, JSON.stringify([filterValue])); // Add or update the query param

    history.push({
      search: searchParams.toString() // Convert back to a query string
    });
  }, [history]);
  const dispatch = (0, _reactRedux.useDispatch)();
  const openFlyout = (0, _react.useCallback)(monitor => {
    const {
      configId,
      locationLabel,
      locationId
    } = monitor;
    dispatch(setFlyoutConfigCallback({
      configId,
      id: configId,
      location: locationLabel,
      locationId,
      spaces: monitor.spaces
    }));
  }, [dispatch, setFlyoutConfigCallback]);
  const columns = (0, _react.useMemo)(() => {
    var _spaces$ui$components;
    const LazySpaceList = (_spaces$ui$components = spaces === null || spaces === void 0 ? void 0 : spaces.ui.components.getSpaceList) !== null && _spaces$ui$components !== void 0 ? _spaces$ui$components : () => null;
    return [{
      name: _labels2.STATUS,
      render: monitor => /*#__PURE__*/_react.default.createElement(_monitor_status_col.MonitorStatusCol, {
        monitor: monitor,
        openFlyout: openFlyout,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 93,
          columnNumber: 11
        }
      })
    }, {
      field: 'name',
      name: _labels2.NAME,
      render: (name, monitor) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        direction: "column",
        alignItems: "flexStart",
        gutterSize: "s",
        className: "clickCellContent",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 100,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 106,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        onClick: () => openFlyout(monitor),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 107,
          columnNumber: 15
        }
      }, name)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 111,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_monitor_type_badge.MonitorTypeBadge, {
        monitorType: monitor.type,
        ariaLabel: (0, _labels.getFilterForTypeMessage)(monitor.type),
        onClick: () => onClickMonitorFilter('monitorTypes', monitor.type),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 112,
          columnNumber: 15
        }
      })))
    }, {
      field: 'urls',
      name: _labels2.URL,
      render: url => url ? /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "syntheticsCompactViewUrl",
        href: url,
        target: "_blank",
        color: "text",
        external: true,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 126,
          columnNumber: 13
        }
      }, url) : /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 136,
          columnNumber: 13
        }
      }, _labels2.NO_URL)
    }, {
      field: 'locationLabel',
      name: _labels2.LOCATIONS,
      render: locationLabel => /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "syntheticsCompactViewLocation",
        onClick: () => onClickMonitorFilter('locations', locationLabel),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 143,
          columnNumber: 11
        }
      }, locationLabel)
    }, {
      field: 'tags',
      name: _labels2.TAGS,
      render: tags => /*#__PURE__*/_react.default.createElement(_public.TagsList, {
        tags: tags,
        onClick: tag => onClickMonitorFilter('tags', tag),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 155,
          columnNumber: 11
        }
      })
    }, {
      name: _labels2.DURATION,
      render: monitor => /*#__PURE__*/_react.default.createElement(_monitors_duration.MonitorsDuration, {
        monitor: monitor,
        onClickDuration: () => openFlyout(monitor),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 161,
          columnNumber: 11
        }
      }),
      width: '100px'
    }, {
      align: 'left',
      field: 'configId',
      name: _labels2.MONITOR_HISTORY,
      mobileOptions: {
        show: false
      },
      width: '220px',
      render: (configId, monitor) => {
        var _histogramsById$uniqI;
        const uniqId = `${configId}-${monitor.locationId}`;
        return /*#__PURE__*/_react.default.createElement(_monitor_bar_series.MonitorBarSeries, {
          histogramSeries: histogramsById === null || histogramsById === void 0 ? void 0 : (_histogramsById$uniqI = histogramsById[uniqId]) === null || _histogramsById$uniqI === void 0 ? void 0 : _histogramsById$uniqI.points,
          minInterval: minInterval,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 176,
            columnNumber: 13
          }
        });
      }
    }, ...(showFromAllSpaces ? [{
      name: _i18n.i18n.translate('xpack.synthetics.management.monitorList.spacesColumnTitle', {
        defaultMessage: 'Spaces'
      }),
      field: 'spaces',
      sortable: true,
      render: monSpaces => {
        return /*#__PURE__*/_react.default.createElement(LazySpaceList, {
          namespaces: monSpaces !== null && monSpaces !== void 0 ? monSpaces : space ? [space === null || space === void 0 ? void 0 : space.id] : [],
          behaviorContext: "outside-space",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 193,
            columnNumber: 19
          }
        });
      }
    }] : []), {
      name: _labels2.ACTIONS,
      render: monitor => /*#__PURE__*/_react.default.createElement(_monitors_actions.MonitorsActions, {
        monitor: monitor,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 204,
          columnNumber: 54
        }
      }),
      align: 'right',
      width: '40px'
    }];
  }, [histogramsById, minInterval, onClickMonitorFilter, openFlyout, showFromAllSpaces, space, spaces === null || spaces === void 0 ? void 0 : spaces.ui.components.getSpaceList]);
  return {
    columns
  };
};
exports.useMonitorsTableColumns = useMonitorsTableColumns;