"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MonitorStatusHeader = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _contexts = require("../../../contexts");
var _use_selected_location = require("../hooks/use_selected_location");
var _runtime_types = require("../../../../../../common/runtime_types");
var _constants = require("../../../../../../common/constants");
var _url_params = require("../../../utils/url_params");
var _use_selected_monitor = require("../hooks/use_selected_monitor");
var labels = _interopRequireWildcard(require("./labels"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/monitor_details/monitor_status/monitor_status_header.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MonitorStatusHeader = ({
  from,
  to,
  periodCaption,
  showViewHistoryButton
}) => {
  var _monitor$ConfigKey$CO;
  const {
    basePath
  } = (0, _contexts.useSyntheticsSettingsContext)();
  const {
    monitor
  } = (0, _use_selected_monitor.useSelectedMonitor)();
  const selectedLocation = (0, _use_selected_location.useSelectedLocation)();
  const search = (0, _url_params.stringifyUrlParams)({
    locationId: selectedLocation === null || selectedLocation === void 0 ? void 0 : selectedLocation.id,
    dateRangeStart: 'now-24h',
    dateRangeEnd: 'now'
  });
  const viewDetailsUrl = `${basePath}/app/synthetics${_constants.MONITOR_HISTORY_ROUTE.replace(':monitorId', (_monitor$ConfigKey$CO = monitor === null || monitor === void 0 ? void 0 : monitor[_runtime_types.ConfigKey.CONFIG_ID]) !== null && _monitor$ConfigKey$CO !== void 0 ? _monitor$ConfigKey$CO : '')}${search}`;
  const isLast24Hours = from === 'now-24h' && to === 'now';
  const periodCaptionText = !!periodCaption ? periodCaption : isLast24Hours ? labels.LAST_24_HOURS_LABEL : '';
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    alignItems: "baseline",
    css: {
      marginBottom: 0
    },
    wrap: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    responsive: false,
    wrap: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h4", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 13
    }
  }, labels.STATUS_LABEL))), periodCaptionText ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 13
    }
  }, periodCaptionText)) : null), showViewHistoryButton ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    css: {
      marginLeft: 'auto'
    },
    href: viewDetailsUrl,
    "data-test-subj": "monitorStatusChartViewHistoryButton",
    size: "xs",
    iconType: "list",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 9
    }
  }, labels.VIEW_HISTORY_LABEL) : null);
};
exports.MonitorStatusHeader = MonitorStatusHeader;