"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MonitorDetailsStatus = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _monitor_status = require("../common/components/monitor_status");
var _use_selected_monitor = require("./hooks/use_selected_monitor");
var _use_monitor_latest_ping = require("./hooks/use_monitor_latest_ping");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/monitor_details/monitor_details_status.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const MonitorDetailsStatus = () => {
  const {
    latestPing,
    loading: pingsLoading
  } = (0, _use_monitor_latest_ping.useMonitorLatestPing)();
  const {
    monitor,
    isMonitorMissing
  } = (0, _use_selected_monitor.useSelectedMonitor)();
  if (!monitor) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
      align: "left",
      compressed: false,
      listItems: [{
        title: _monitor_status.STATUS_LABEL,
        description: isMonitorMissing ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null) : /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
          lines: 1,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 27,
            columnNumber: 53
          }
        })
      }],
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 21,
        columnNumber: 7
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_monitor_status.MonitorStatus, {
    status: latestPing === null || latestPing === void 0 ? void 0 : latestPing.monitor.status,
    monitor: monitor,
    loading: pingsLoading,
    compressed: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 5
    }
  });
};
exports.MonitorDetailsStatus = MonitorDetailsStatus;