"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSelectedMonitor = void 0;
var _react = require("react");
var _reactRedux = require("react-redux");
var _reactRouterDom = require("react-router-dom");
var _use_kibana_space = require("../../../../../hooks/use_kibana_space");
var _runtime_types = require("../../../../../../common/runtime_types");
var _contexts = require("../../../contexts");
var _state = require("../../../state");
var _hooks = require("../../../hooks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useSelectedMonitor = ({
  refetchMonitorEnabled = true
} = {}) => {
  var _error$body, _error$getPayload;
  const {
    monitorId
  } = (0, _reactRouterDom.useParams)();
  const {
    space
  } = (0, _use_kibana_space.useKibanaSpace)();
  const {
    spaceId
  } = (0, _hooks.useGetUrlParams)();
  const monitorsList = (0, _reactRedux.useSelector)(_state.selectEncryptedSyntheticsSavedMonitors);
  const {
    loading: monitorListLoading
  } = (0, _reactRedux.useSelector)(_state.selectMonitorListState);
  const monitorFromList = (0, _react.useMemo)(() => {
    var _monitorsList$find;
    return (_monitorsList$find = monitorsList.find(monitor => monitor[_runtime_types.ConfigKey.CONFIG_ID] === monitorId)) !== null && _monitorsList$find !== void 0 ? _monitorsList$find : null;
  }, [monitorId, monitorsList]);
  const error = (0, _reactRedux.useSelector)(_state.selectSyntheticsMonitorError);
  const {
    lastRefresh,
    refreshInterval
  } = (0, _contexts.useSyntheticsRefreshContext)();
  const {
    syntheticsMonitor,
    syntheticsMonitorLoading,
    syntheticsMonitorDispatchedAt
  } = (0, _reactRedux.useSelector)(_state.selectorMonitorDetailsState);
  const dispatch = (0, _reactRedux.useDispatch)();
  const isMonitorFromListValid = monitorId && monitorFromList && monitorFromList[_runtime_types.ConfigKey.CONFIG_ID] === monitorId;
  const isLoadedSyntheticsMonitorValid = monitorId && syntheticsMonitor && syntheticsMonitor[_runtime_types.ConfigKey.CONFIG_ID] === monitorId;
  const availableMonitor = isLoadedSyntheticsMonitorValid ? syntheticsMonitor : isMonitorFromListValid ? monitorFromList : null;
  const isMonitorMissing = (error === null || error === void 0 ? void 0 : (_error$body = error.body) === null || _error$body === void 0 ? void 0 : _error$body.statusCode) === 404 && ((_error$getPayload = error.getPayload) === null || _error$getPayload === void 0 ? void 0 : _error$getPayload.monitorId) === monitorId;
  (0, _react.useEffect)(() => {
    if (monitorId && !availableMonitor && !syntheticsMonitorLoading && !isMonitorMissing) {
      dispatch(_state.getMonitorAction.get({
        monitorId,
        ...(spaceId && spaceId !== (space === null || space === void 0 ? void 0 : space.id) ? {
          spaceId
        } : {})
      }));
    }
  }, [dispatch, monitorId, availableMonitor, syntheticsMonitorLoading, isMonitorMissing, spaceId, space === null || space === void 0 ? void 0 : space.id]);
  (0, _react.useEffect)(() => {
    // Only perform periodic refresh if the last dispatch was earlier enough
    if (monitorId && !syntheticsMonitorLoading && !monitorListLoading && syntheticsMonitorDispatchedAt > 0 && Date.now() - syntheticsMonitorDispatchedAt > refreshInterval * 1000 && refetchMonitorEnabled) {
      dispatch(_state.getMonitorAction.get({
        monitorId,
        ...(spaceId && spaceId !== (space === null || space === void 0 ? void 0 : space.id) ? {
          spaceId
        } : {})
      }));
    }
  }, [dispatch, lastRefresh, refreshInterval, monitorId, monitorListLoading, syntheticsMonitorLoading, syntheticsMonitorDispatchedAt, spaceId, space === null || space === void 0 ? void 0 : space.id, refetchMonitorEnabled]);
  return {
    monitor: availableMonitor,
    loading: syntheticsMonitorLoading || monitorListLoading,
    error,
    isMonitorMissing
  };
};
exports.useSelectedMonitor = useSelectedMonitor;