"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFetchActiveAlerts = useFetchActiveAlerts;
var _common = require("@kbn/rule-registry-plugin/common");
var _technical_rule_data_field_names = require("@kbn/rule-registry-plugin/common/technical_rule_data_field_names");
var _public = require("@kbn/observability-shared-plugin/public");
var _public2 = require("@kbn/kibana-react-plugin/public");
var _reactRouterDom = require("react-router-dom");
var _use_selected_location = require("./use_selected_location");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useFetchActiveAlerts() {
  var _data$hits$total$valu, _data$hits;
  const {
    http
  } = (0, _public2.useKibana)().services;
  const {
    monitorId: configId
  } = (0, _reactRouterDom.useParams)();
  const selectedLocation = (0, _use_selected_location.useSelectedLocation)();
  const {
    loading,
    data
  } = (0, _public.useFetcher)(async () => {
    return await http.post(`${_common.BASE_RAC_ALERTS_API_PATH}/find`, {
      body: JSON.stringify({
        rule_type_ids: _technical_rule_data_field_names.SYNTHETICS_RULE_TYPE_IDS,
        consumers: [_technical_rule_data_field_names.AlertConsumers.UPTIME, _technical_rule_data_field_names.AlertConsumers.ALERTS, _technical_rule_data_field_names.AlertConsumers.OBSERVABILITY],
        size: 0,
        track_total_hits: true,
        query: {
          bool: {
            filter: [{
              range: {
                '@timestamp': {
                  gte: 'now-24h/h'
                }
              }
            }, {
              term: {
                configId
              }
            }, {
              term: {
                'location.id': selectedLocation === null || selectedLocation === void 0 ? void 0 : selectedLocation.id
              }
            }, {
              term: {
                'kibana.alert.status': 'active'
              }
            }]
          }
        }
      })
    });
  }, [configId, http, selectedLocation === null || selectedLocation === void 0 ? void 0 : selectedLocation.id]);
  return {
    loading,
    data,
    numberOfActiveAlerts: (_data$hits$total$valu = data === null || data === void 0 ? void 0 : (_data$hits = data.hits) === null || _data$hits === void 0 ? void 0 : _data$hits.total.value) !== null && _data$hits$total$valu !== void 0 ? _data$hits$total$valu : 0
  };
}