"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StepFields = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _reactHookForm = require("react-hook-form");
var _step = require("./step");
var _form_config = require("../form/form_config");
var _field = require("../form/field");
var _types = require("../types");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/monitor_add_edit/steps/step_fields.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const StepFields = ({
  description,
  stepKey,
  readOnly = false,
  descriptionOnly = false
}) => {
  var _formConfig$stepKey;
  const {
    watch,
    formState: {
      errors
    }
  } = (0, _reactHookForm.useFormContext)();
  const [type] = watch([_types.ConfigKey.FORM_MONITOR_TYPE]);
  const formConfig = (0, _react.useMemo)(() => {
    return (0, _form_config.FORM_CONFIG)(readOnly)[type];
  }, [readOnly, type]);
  return descriptionOnly ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 5
    }
  }, description) : /*#__PURE__*/_react.default.createElement(_step.Step, {
    description: description,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 5
    }
  }, (_formConfig$stepKey = formConfig[stepKey]) === null || _formConfig$stepKey === void 0 ? void 0 : _formConfig$stepKey.map(field => {
    return /*#__PURE__*/_react.default.createElement(_field.Field, (0, _extends2.default)({}, field, {
      key: field.fieldKey,
      fieldError: errors[field.fieldKey],
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 45,
        columnNumber: 11
      }
    }));
  }));
};
exports.StepFields = StepFields;