"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MwsCalloutContent = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _create_maintenance_windows_btn = require("../../monitor_add_edit/fields/maintenance_windows/create_maintenance_windows_btn");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/common/mws_callout/mws_callout_content.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const MwsCalloutContent = ({
  activeMWs
}) => {
  if (activeMWs.length) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: _i18n.i18n.translate('xpack.synthetics.maintenanceWindowCallout.maintenanceWindowActive.monitors', {
        defaultMessage: 'Maintenance windows are active'
      }),
      color: "warning",
      iconType: "info",
      "data-test-subj": "maintenanceWindowCallout",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 17,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('xpack.synthetics.maintenanceWindowCallout.maintenanceWindowActiveDescription.monitors', {
      defaultMessage: 'Monitors are stopped while maintenance windows are running. Active maintenance windows are '
    }), activeMWs.map((mws, index) => /*#__PURE__*/_react.default.createElement("span", {
      key: mws.id,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 36,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_create_maintenance_windows_btn.MaintenanceWindowsLink, {
      id: mws.id,
      label: mws.title,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 37,
        columnNumber: 15
      }
    }), index !== activeMWs.length - 1 ? /*#__PURE__*/_react.default.createElement("span", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 38,
        columnNumber: 49
      }
    }, ", ") : /*#__PURE__*/_react.default.createElement("span", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 38,
        columnNumber: 67
      }
    }, ".")))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 42,
        columnNumber: 9
      }
    }));
  } else {
    return null;
  }
};
exports.MwsCalloutContent = MwsCalloutContent;