"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleMonitorsTable = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _reactRedux = require("react-redux");
var _lodash = require("lodash");
var _selectors = require("../../state/alert_rules/selectors");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/alerts/rule_monitors_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const RuleMonitorsTable = () => {
  var _uniqBy, _data$monitors;
  const {
    services: {
      http
    }
  } = (0, _public.useKibana)();
  const {
    data
  } = (0, _reactRedux.useSelector)(_selectors.selectInspectRule);
  const [pageIndex, setPageIndex] = _react.default.useState(0);
  const [pageSize, setPageSize] = _react.default.useState(10);
  const onTableChange = ({
    page
  }) => {
    if (page) {
      setPageIndex(page.index);
      setPageSize(page.size);
    }
  };
  const columns = [{
    field: 'name',
    name: _i18n.i18n.translate('xpack.synthetics.ruleDetails.monitorsTable.nameColumn', {
      defaultMessage: 'Name'
    }),
    render: (name, monitor) => /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      "data-test-subj": "ColumnsLink",
      href: http.basePath.prepend(`/app/synthetics/monitor/${monitor.id}`),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 41,
        columnNumber: 9
      }
    }, name)
  }, {
    field: 'id',
    name: _i18n.i18n.translate('xpack.synthetics.ruleDetails.monitorsTable.idColumn', {
      defaultMessage: 'ID'
    })
  }, {
    field: 'type',
    name: _i18n.i18n.translate('xpack.synthetics.ruleDetails.monitorsTable.type', {
      defaultMessage: 'Type'
    })
  }];
  const search = {
    box: {
      incremental: true,
      schema: true
    },
    filters: [{
      type: 'field_value_selection',
      field: 'type',
      name: _i18n.i18n.translate('xpack.synthetics.ruleDetails.monitorsTable.typeFilter', {
        defaultMessage: 'Type'
      }),
      multiSelect: false,
      options: (_uniqBy = (0, _lodash.uniqBy)(data === null || data === void 0 ? void 0 : data.monitors.map(monitor => ({
        value: monitor.type,
        name: monitor.type
      })), 'value')) !== null && _uniqBy !== void 0 ? _uniqBy : []
    }]
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    tableLayout: "auto",
    css: {
      width: 600
    },
    items: (_data$monitors = data === null || data === void 0 ? void 0 : data.monitors) !== null && _data$monitors !== void 0 ? _data$monitors : [],
    columns: columns,
    onChange: onTableChange,
    search: search,
    pagination: {
      pageIndex,
      pageSize,
      showPerPageOptions: true
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 5
    }
  });
};
exports.RuleMonitorsTable = RuleMonitorsTable;