"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.aliases = void 0;
exports.getRegularEcsField = getRegularEcsField;
exports.isNamespacedEcsField = isNamespacedEcsField;
exports.namespacePrefixes = exports.keepFields = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const keepFields = exports.keepFields = ['@timestamp', 'observed_timestamp', 'trace_id', 'span_id', 'severity_text', 'body', 'severity_number', 'event_name', 'dropped_attributes_count', 'scope', 'body.text', 'body.structured', 'resource.schema_url', 'resource.dropped_attributes_count'];
const aliases = exports.aliases = {
  trace_id: 'trace.id',
  span_id: 'span.id',
  severity_text: 'log.level',
  'body.text': 'message'
};
const namespacePrefixes = exports.namespacePrefixes = ['body.structured.', 'attributes.', 'scope.attributes.', 'resource.attributes.'];
function getRegularEcsField(field) {
  // check whether it starts with a namespace prefix
  for (const prefix of namespacePrefixes) {
    if (field.startsWith(prefix)) {
      return field.slice(prefix.length);
    }
  }
  // check aliases
  if (aliases[field]) {
    return aliases[field];
  }
  return field;
}
function isNamespacedEcsField(field) {
  return namespacePrefixes.some(prefix => field.startsWith(prefix)) || keepFields.includes(field);
}