"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.contentStorageSettings = exports.ContentClient = void 0;
var _storageAdapter = require("@kbn/storage-adapter");
var _objectHash = _interopRequireDefault(require("object-hash"));
var _fields = require("./fields");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const contentStorageSettings = exports.contentStorageSettings = {
  name: '.kibana_streams_content_packs',
  schema: {
    properties: {
      [_fields.STREAM_NAME]: _storageAdapter.types.keyword(),
      [_fields.CONTENT_NAME]: _storageAdapter.types.keyword(),
      dashboards: _storageAdapter.types.object(),
      'dashboards.source_id': _storageAdapter.types.keyword(),
      'dashboards.target_id': _storageAdapter.types.keyword(),
      'dashboards.references': _storageAdapter.types.object(),
      'dashboards.references.source_id': _storageAdapter.types.keyword(),
      'dashboards.references.target_id': _storageAdapter.types.keyword()
    }
  }
};
class ContentClient {
  constructor(clients) {
    this.clients = clients;
  }
  async getStoredContentPacks(streamName) {
    const response = await this.clients.storageClient.search({
      size: 10_000,
      track_total_hits: false,
      query: {
        bool: {
          filter: [{
            term: {
              [_fields.STREAM_NAME]: streamName
            }
          }]
        }
      }
    });
    return response.hits.hits.map(hit => hit._source);
  }
  async getStoredContentPack(streamName, contentName) {
    const id = (0, _objectHash.default)({
      streamName,
      contentName
    });
    const response = await this.clients.storageClient.get({
      id
    });
    return response._source;
  }
  async upsertStoredContentPack(streamName, content) {
    const id = (0, _objectHash.default)({
      streamName,
      contentName: content.name
    });
    await this.clients.storageClient.index({
      id,
      document: {
        [_fields.STREAM_NAME]: streamName,
        [_fields.CONTENT_NAME]: content.name,
        dashboards: content.dashboards
      }
    });
  }
}
exports.ContentClient = ContentClient;