"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDocumentExpansion = void 0;
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useDocumentExpansion = hits => {
  const [currentDoc, setExpandedDoc] = (0, _react.useState)(undefined);
  const currentDocRef = (0, _react.useRef)(currentDoc);
  currentDocRef.current = currentDoc;
  const hitsRef = (0, _react.useRef)(hits);
  hitsRef.current = hits;

  // Calculate selected row index from current document
  const selectedRowIndex = hits.findIndex(hit => hit === currentDoc);
  const onRowSelected = (0, _react.useCallback)(rowIndex => {
    if (currentDocRef.current && hitsRef.current[rowIndex] === currentDocRef.current) {
      // If the same row is clicked, collapse the flyout
      setExpandedDoc(undefined);
      return;
    }
    // Expand the clicked row
    setExpandedDoc(hitsRef.current[rowIndex]);
  }, []);
  (0, _react.useEffect)(() => {
    if (currentDoc) {
      // If a current doc is set but not in the hits, update it to point to the newly mapped hit with the same index
      const hit = hits.find(h => h.index === currentDoc.index);
      if (hit && hit !== currentDoc) {
        setExpandedDoc(hit);
      } else if (!hit && currentDoc) {
        // If the current doc is not found in the hits, reset it
        setExpandedDoc(undefined);
      }
    }
  }, [currentDoc, hits]);
  return {
    currentDoc,
    selectedRowIndex,
    onRowSelected,
    setExpandedDoc
  };
};
exports.useDocumentExpansion = useDocumentExpansion;