"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAnnotationFromFormattedChangePoint = getAnnotationFromFormattedChangePoint;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _change_point_summary = require("../change_point_summary");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/streams_app/public/components/stream_detail_significant_events_view/utils/get_annotation_from_formatted_change_point.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function getAnnotationFromFormattedChangePoint({
  query: {
    id
  },
  theme,
  change,
  xFormatter
}) {
  const color = theme.colors[change === null || change === void 0 ? void 0 : change.color];
  return {
    color,
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "dot",
      color: color,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 28,
        columnNumber: 11
      }
    }),
    id: `change_point_${id}`,
    label: /*#__PURE__*/_react.default.createElement(_change_point_summary.ChangePointSummary, {
      xFormatter: xFormatter,
      change: change,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 30,
        columnNumber: 12
      }
    }),
    x: change.time
  };
}