"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RedirectTo = RedirectTo;
var _react = require("react");
var _lodash = require("lodash");
var _use_streams_app_router = require("../../hooks/use_streams_app_router");
var _use_streams_app_params = require("../../hooks/use_streams_app_params");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function RedirectTo({
  children,
  path,
  params
}) {
  const router = (0, _use_streams_app_router.useStreamsAppRouter)();
  const currentParams = (0, _use_streams_app_params.useStreamsAppParams)('/*');
  (0, _react.useLayoutEffect)(() => {
    router.replace(path, ...[(0, _lodash.merge)({}, currentParams, params)]);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  return children !== null && children !== void 0 ? children : null;
}