"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useMatchRate = void 0;
var _react = require("react");
var _react2 = require("@xstate5/react");
var _xstate = require("xstate5");
var _formatters = require("../../../../util/formatters");
var _use_timefilter = require("../../../../hooks/use_timefilter");
var _use_kibana = require("../../../../hooks/use_kibana");
var _routing_samples_state_machine = require("../state_management/stream_routing_state_machine/routing_samples_state_machine");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const percentageFormatter = (0, _formatters.getPercentageFormatter)({
  precision: 2
});
const useMatchRate = (definition, partition) => {
  const {
    data
  } = (0, _use_kibana.useKibana)().dependencies.start;
  const {
    timeState
  } = (0, _use_timefilter.useTimefilter)();

  // Re-use logic from the machine definition to retrieve the match rate for the partitions
  const actorInstance = (0, _react.useMemo)(() => {
    const actor = (0, _xstate.createActor)((0, _routing_samples_state_machine.createDocumentsCountCollectorActor)({
      data
    }), {
      input: {
        condition: partition.condition,
        definition,
        documentMatchFilter: 'matched'
      }
    });
    actor.start();
    return actor;
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [data, partition.condition, definition, timeState.start, timeState.end] // Actor restarts when these change
  );
  (0, _react.useEffect)(() => {
    return () => {
      actorInstance.stop();
    };
  }, [actorInstance]);
  const value = (0, _react2.useSelector)(actorInstance, snapshot => {
    var _snapshot$context;
    return snapshot.status === 'done' ? percentageFormatter.format((_snapshot$context = snapshot.context) !== null && _snapshot$context !== void 0 ? _snapshot$context : 0) : undefined;
  });
  const loading = (0, _react2.useSelector)(actorInstance, snapshot => snapshot.status === 'active');
  return {
    value,
    loading
  };
};
exports.useMatchRate = useMatchRate;