"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NewRoutingStreamEntry = NewRoutingStreamEntry;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _control_bars = require("./control_bars");
var _stream_routing_state_machine = require("./state_management/stream_routing_state_machine");
var _routing_condition_editor = require("./routing_condition_editor");
var _stream_name_form_row = require("./stream_name_form_row");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/stream_detail_routing/new_routing_stream_entry.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function NewRoutingStreamEntry() {
  const panelRef = (0, _react.useRef)(null);
  const {
    changeRule
  } = (0, _stream_routing_state_machine.useStreamRoutingEvents)();
  const currentRule = (0, _stream_routing_state_machine.useStreamsRoutingSelector)(snapshot => (0, _stream_routing_state_machine.selectCurrentRule)(snapshot.context));
  (0, _react.useEffect)(() => {
    if (panelRef.current) {
      panelRef.current.scrollIntoView({
        behavior: 'smooth',
        block: 'center'
      });
    }
  }, []);
  return /*#__PURE__*/_react.default.createElement("div", {
    ref: panelRef,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 33,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true,
    paddingSize: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    direction: "column",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_stream_name_form_row.StreamNameFormRow, {
    value: currentRule.destination,
    onChange: value => changeRule({
      destination: value
    }),
    autoFocus: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    direction: "column",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_routing_condition_editor.RoutingConditionEditor, {
    condition: currentRule.where,
    status: currentRule.status,
    onConditionChange: cond => changeRule({
      where: cond
    }),
    onStatusChange: status => changeRule({
      status
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "GrayText",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.streams.conditionEditor.filterTip', {
    defaultMessage: 'Tip: You can add a condition directly from a table cell.'
  }))), /*#__PURE__*/_react.default.createElement(_control_bars.AddRoutingRuleControls, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 11
    }
  }))));
}