"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IdleRoutingStreamEntry = IdleRoutingStreamEntry;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _streamsSchema = require("@kbn/streams-schema");
var _css = require("@emotion/css");
var _react2 = require("@emotion/react");
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _use_streams_app_router = require("../../../hooks/use_streams_app_router");
var _shared = require("../shared");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/stream_detail_routing/idle_routing_stream_entry.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function VerticalRule() {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const CentralizedContainer = _styled.default.div`
    display: flex;
    align-items: center;
    padding: 0 ${euiTheme.size.xs};
  `;
  const Border = _styled.default.div`
    height: 20px;
    border-right: ${euiTheme.border.thin};
  `;
  return /*#__PURE__*/_react.default.createElement(CentralizedContainer, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(Border, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 7
    }
  }));
}
function IdleRoutingStreamEntry({
  availableStreams,
  draggableProvided,
  isEditingEnabled,
  onEditIconClick,
  routingRule,
  canReorder
}) {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const router = (0, _use_streams_app_router.useStreamsAppRouter)();
  const childrenCount = availableStreams.filter(stream => (0, _streamsSchema.isDescendantOf)(routingRule.destination, stream)).length;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true,
    "data-test-subj": `routingRule-${routingRule.destination}`,
    className: (0, _css.css)`
        overflow: hidden;
        .streamsDragHandle {
          transition: margin-left ${euiTheme.animation.normal};
          padding: ${euiTheme.size.s} 0;
          margin-left: -${euiTheme.size.xl};
        }
        &:hover .streamsDragHandle {
          margin-left: 0;
        }
        padding: ${euiTheme.size.m} 16px;
        border-radius: ${euiTheme.size.s};
      `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexStart",
    gutterSize: "xs",
    alignItems: "center",
    responsive: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 9
    }
  }, canReorder && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, (0, _extends2.default)({
    className: "streamsDragHandle",
    color: "transparent",
    paddingSize: "s",
    "data-test-subj": `routingRuleDragHandle-${routingRule.destination}`
  }, draggableProvided.dragHandleProps, {
    "aria-label": _i18n.i18n.translate('xpack.streams.idleRoutingStreamEntry.euiPanel.dragHandleLabel', {
      defaultMessage: 'Drag Handle'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "grabOmnidirectional",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: router.link('/{key}/management/{tab}', {
      path: {
        key: routingRule.destination,
        tab: 'partitioning'
      }
    }),
    "data-test-subj": "streamsAppRoutingStreamEntryButton",
    css: (0, _react2.css)`
              min-width: 0;
            `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    component: "p",
    className: "eui-textTruncate",
    css: (0, _react2.css)`
                font-weight: ${euiTheme.font.weight.bold};
              `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 13
    }
  }, routingRule.destination)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    gutterSize: "xs",
    alignItems: "center",
    responsive: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 11
    }
  }, !(0, _streamsSchema.isRoutingEnabled)(routingRule.status) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "subdued",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 17
    }
  }, _i18n.i18n.translate('xpack.streams.streamDetailRouting.disabled', {
    defaultMessage: 'Disabled'
  })), /*#__PURE__*/_react.default.createElement(VerticalRule, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 17
    }
  })), childrenCount > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _i18n.i18n.translate('xpack.streams.streamDetailRouting.numberChildrenTooltip', {
      defaultMessage: 'Number of child streams'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "hollow",
    tabIndex: 0,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 19
    }
  }, `+${childrenCount}`)), /*#__PURE__*/_react.default.createElement(VerticalRule, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": `routingRuleEditButton-${routingRule.destination}`,
    iconType: "pencil",
    disabled: !isEditingEnabled,
    onClick: () => onEditIconClick(routingRule.id),
    "aria-label": _i18n.i18n.translate('xpack.streams.streamDetailRouting.edit', {
      defaultMessage: 'Edit'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    className: (0, _css.css)`
            overflow: hidden;
            padding: ${euiTheme.size.xs} 0px;
          `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 179,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_shared.ConditionPanel, {
    condition: routingRule.where,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 186,
      columnNumber: 11
    }
  }))));
}