"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildCellActions = buildCellActions;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _stream_routing_state_machine = require("../state_management/stream_routing_state_machine");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/stream_detail_routing/cell_actions/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const getOperator = (value, mode) => {
  if (typeof value === 'boolean') {
    return 'exists';
  }
  return mode === '+' ? 'eq' : 'neq';
};
const getCondition = (value, operator) => {
  if (typeof value === 'boolean') {
    return {
      exists: value
    };
  }
  return {
    [operator]: `${value}`
  };
};
const FilterBtn = ({
  cellActionProps: {
    Component,
    rowIndex,
    columnId
  },
  context,
  onCreate,
  onFilter,
  mode
}) => {
  const routingSnapshot = (0, _stream_routing_state_machine.useStreamsRoutingSelector)(snapshot => snapshot);
  const isRuleActive = routingSnapshot.matches({
    ready: {
      creatingNewRule: 'changing'
    }
  });
  const currentRule = isRuleActive ? (0, _stream_routing_state_machine.selectCurrentRule)(routingSnapshot.context) : {};
  const iconType = mode === '+' ? 'plusInCircle' : 'minusInCircle';
  const operator = getOperator(context[rowIndex][columnId], mode);
  const condition = getCondition(context[rowIndex][columnId], operator);
  const buttonTitle = _i18n.i18n.translate('xpack.streams.routing.condition.filter', {
    defaultMessage: 'Add routing condition: {operator}',
    values: {
      operator: operator === 'eq' ? 'equals' : operator === 'neq' ? 'not equals' : 'exists'
    }
  });
  return /*#__PURE__*/_react.default.createElement(Component, {
    onClick: () => {
      if (!isRuleActive) {
        onCreate();
      }
      onFilter({
        ...currentRule,
        where: {
          field: columnId,
          ...condition
        }
      });
    },
    iconType: iconType,
    "aria-label": buttonTitle,
    title: buttonTitle,
    "data-test-subj": "routingConditionFilterForButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 5
    }
  });
};
function buildCellActions(context, onCreate, onFilter) {
  return [cellActionProps => FilterBtn({
    cellActionProps,
    context,
    onCreate,
    onFilter,
    mode: '+'
  }), cellActionProps => FilterBtn({
    cellActionProps,
    context,
    onCreate,
    onFilter,
    mode: '-'
  })];
}