"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WiredAdvancedView = WiredAdvancedView;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _streamsSchema = require("@kbn/streams-schema");
var _eui = require("@elastic/eui");
var _stream_feature_configuration = require("./stream_feature_configuration");
var _index_configuration = require("./advanced_view/index_configuration");
var _delete_stream = require("./advanced_view/delete_stream");
var _import_export = require("./advanced_view/import_export");
var _use_streams_privileges = require("../../../hooks/use_streams_privileges");
var _stream_description = require("./stream_description");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/stream_detail_management/wired_advanced_view.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function WiredAdvancedView({
  definition,
  refreshDefinition
}) {
  const {
    features: {
      contentPacks,
      significantEvents
    }
  } = (0, _use_streams_privileges.useStreamsPrivileges)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, (contentPacks === null || contentPacks === void 0 ? void 0 : contentPacks.enabled) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_import_export.ImportExportPanel, {
    definition: definition,
    refreshDefinition: refreshDefinition,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 11
    }
  })), (significantEvents === null || significantEvents === void 0 ? void 0 : significantEvents.available) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_stream_description.StreamDescription, {
    definition: definition,
    refreshDefinition: refreshDefinition,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_stream_feature_configuration.StreamFeatureConfiguration, {
    definition: definition.stream,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_index_configuration.IndexConfiguration, {
    definition: definition,
    refreshDefinition: refreshDefinition,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    iconType: "warning",
    color: "primary",
    title: _i18n.i18n.translate('xpack.streams.streamDetailView.indexConfiguration.inheritSettingsTitle', {
      defaultMessage: 'Changes will be inherited by child streams unless they override them explicitly.'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 9
    }
  })), !(0, _streamsSchema.isRoot)(definition.stream.name) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_delete_stream.DeleteStreamPanel, {
    definition: definition,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 7
    }
  }));
}