"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ActionBlockListItem = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _streamlang = require("@kbn/streamlang");
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _react3 = require("@xstate5/react");
var _processor_metrics = require("./processor_metrics");
var _utils = require("./utils");
var _processor_status_indicator = require("./processor_status_indicator");
var _utils2 = require("../../../utils");
var _context_menu = require("../context_menu");
var _block_disable_overlay = require("../block_disable_overlay");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/stream_detail_enrichment/steps/blocks/action/list_item.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ActionBlockListItem = ({
  processorMetrics,
  stepRef,
  level,
  stepUnderEdit,
  rootLevelMap,
  stepsProcessingSummaryMap,
  isFirstStepInLevel,
  isLastStepInLevel
}) => {
  const step = (0, _react3.useSelector)(stepRef, snapshot => snapshot.context.step);
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const isUnsaved = (0, _react3.useSelector)(stepRef, snapshot => snapshot.context.isNew || snapshot.context.isUpdated);

  // For the inner description we once again invert the colours
  const descriptionPanelColour = (0, _utils2.getStepPanelColour)(level + 1);
  if (!(0, _streamlang.isActionBlock)(step)) return null;
  const stepDescription = (0, _utils.getStepDescription)(step);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, stepUnderEdit && rootLevelMap.get(stepUnderEdit.customIdentifier) === rootLevelMap.get(step.customIdentifier) && /*#__PURE__*/_react.default.createElement(_block_disable_overlay.BlockDisableOverlay, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 54
    }
  }), stepUnderEdit && !step.parentId && /*#__PURE__*/_react.default.createElement(_block_disable_overlay.BlockDisableOverlay, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 43
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    responsive: false,
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_processor_status_indicator.ProcessorStatusIndicator, {
    stepRef: stepRef,
    stepsProcessingSummaryMap: stepsProcessingSummaryMap,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    css: (0, _react2.css)`
                min-width: 0;
                margin-right: ${euiTheme.size.s};
              `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("strong", {
    "data-test-subj": "streamsAppProcessorLegend",
    css: (0, _react2.css)`
                  display: block;
                  ${(0, _eui.euiTextTruncate)()}
                `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 15
    }
  }, step.action.toUpperCase())), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 15
    }
  }, processorMetrics && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_processor_metrics.ProcessorMetricBadges, (0, _extends2.default)({}, processorMetrics, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 21
    }
  }))), isUnsaved && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 21
    }
  }, _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.ProcessorConfiguration.unsavedBadge', {
    defaultMessage: 'Unsaved'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_context_menu.StepContextMenu, {
    stepRef: stepRef,
    stepUnderEdit: stepUnderEdit,
    isFirstStepInLevel: isFirstStepInLevel,
    isLastStepInLevel: isLastStepInLevel,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 19
    }
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    color: descriptionPanelColour,
    css: (0, _react2.css)`
              padding: ${euiTheme.size.xs} ${euiTheme.size.s};
            `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextTruncate, {
    text: stepDescription,
    truncation: "end",
    children: () => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      color: "subdued",
      css: (0, _react2.css)`
                    font-family: ${euiTheme.font.familyCode};
                  `,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 132,
        columnNumber: 17
      }
    }, stepDescription),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 13
    }
  })))));
};
exports.ActionBlockListItem = ActionBlockListItem;