"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ActionBlock = ActionBlock;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = require("@xstate5/react");
var _react2 = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _useFirstMountState = require("react-use/lib/useFirstMountState");
var _react3 = require("@emotion/react");
var _stream_enrichment_state_machine = require("../../../state_management/stream_enrichment_state_machine");
var _steps_state_machine = require("../../../state_management/steps_state_machine");
var _editor = require("./editor");
var _list_item = require("./list_item");
var _utils = require("../../../utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/stream_detail_enrichment/steps/blocks/action/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ActionBlock(props) {
  const {
    stepRef,
    level
  } = props;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const isUnderEdit = (0, _react.useSelector)(stepRef, snapshot => (0, _steps_state_machine.isStepUnderEdit)(snapshot));
  const isRootStepValue = (0, _react.useSelector)(stepRef, snapshot => (0, _steps_state_machine.isRootStep)(snapshot));
  const simulation = (0, _stream_enrichment_state_machine.useSimulatorSelector)(snapshot => snapshot.context.simulation);
  const panelColour = (0, _utils.getStepPanelColour)(level);
  const processorMetrics = simulation === null || simulation === void 0 ? void 0 : simulation.processors_metrics[stepRef.id];
  const isFirstMount = (0, _useFirstMountState.useFirstMountState)();
  const freshBlockRef = (0, _react2.useRef)(null);
  (0, _react2.useEffect)(() => {
    if (isFirstMount && isUnderEdit && freshBlockRef.current) {
      freshBlockRef.current.scrollIntoView({
        behavior: 'smooth',
        block: 'start',
        inline: 'nearest'
      });
    }
  }, [isFirstMount, isUnderEdit]);
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiPanel, {
    "data-test-subj": "streamsAppProcessorBlock",
    hasShadow: false,
    color: isUnderEdit && isRootStepValue ? undefined : panelColour,
    css: isUnderEdit ?
    // eslint-disable-next-line @elastic/eui/no-css-color
    (0, _react3.css)`
              border: 1px solid ${euiTheme.colors.borderStrongPrimary};
              box-sizing: border-box;
              padding: ${euiTheme.size.m};
            ` : (0, _react3.css)`
              border: ${euiTheme.border.thin};
              border-radius: ${euiTheme.size.s};
              padding: ${euiTheme.size.m};
            `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 5
    }
  }, isUnderEdit ? /*#__PURE__*/_react2.default.createElement(_editor.ActionBlockEditor, (0, _extends2.default)({}, props, {
    ref: freshBlockRef,
    processorMetrics: processorMetrics,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 9
    }
  })) : /*#__PURE__*/_react2.default.createElement(_list_item.ActionBlockListItem, (0, _extends2.default)({}, props, {
    processorMetrics: processorMetrics,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 9
    }
  })));
}