"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.renameProcessorConfig = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _streamlang = require("@kbn/streamlang");
var _utils = require("../utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/stream_detail_enrichment/steps/blocks/action/config_driven/configs/rename.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const defaultFormState = {
  action: 'rename',
  from: '',
  to: '',
  ignore_missing: false,
  override: false,
  where: _streamlang.ALWAYS_CONDITION,
  ignore_failure: false
};
const fieldOptions = {
  fieldKey: 'from',
  fieldHelpText: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.renameFieldHelpText', {
    defaultMessage: 'The field to be renamed.'
  }),
  includeCondition: true,
  includeIgnoreFailures: true,
  includeIgnoreMissing: true
};
const fieldConfigurations = [{
  field: 'to',
  type: 'string',
  required: true,
  label: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.renameTargetFieldLabel', {
    defaultMessage: 'Target field'
  }),
  helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.streams.streamDetailView.managementTab.enrichment.processor.renameTargetFieldHelpText",
    defaultMessage: "The new name of the field.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 7
    }
  })
}, {
  field: 'override',
  type: 'boolean',
  required: false,
  label: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.renameOverrideLabel', {
    defaultMessage: 'Override'
  }),
  helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.streams.streamDetailView.managementTab.enrichment.processor.renameOverrideHelpText",
    defaultMessage: "If true, the processor will update pre-existing non-null-valued fields. When set to false, such fields will not be touched.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 7
    }
  })
}];
const renameProcessorConfig = exports.renameProcessorConfig = {
  type: 'rename',
  inputDisplay: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.renameInputDisplay', {
    defaultMessage: 'Rename'
  }),
  getDocUrl: docLinks => {
    return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.streams.streamDetailView.managementTab.enrichment.processor.renameHelpText",
      defaultMessage: "{renameLink} If the field doesn't exist or the new name is already used, an exception will be thrown.",
      values: {
        renameLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          "data-test-subj": "streamsAppAvailableProcessorsRenameLink",
          external: true,
          target: "_blank",
          href: docLinks.links.ingest.rename,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 96,
            columnNumber: 13
          }
        }, _i18n.i18n.translate('xpack.streams.availableProcessors.renameLinkLabel', {
          defaultMessage: 'Renames an existing field.'
        }))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 91,
        columnNumber: 7
      }
    });
  },
  defaultFormState,
  convertFormStateToConfig: (0, _utils.getConvertFormStateToConfig)(fieldConfigurations, fieldOptions),
  convertProcessorToFormState: (0, _utils.getConvertProcessorToFormState)(defaultFormState),
  fieldConfigurations,
  fieldOptions
};