"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.appendProcessorConfig = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _streamlang = require("@kbn/streamlang");
var _utils = require("../utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/stream_detail_enrichment/steps/blocks/action/config_driven/configs/append.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const defaultFormState = {
  action: 'append',
  to: '',
  value: [],
  allow_duplicates: false,
  where: _streamlang.ALWAYS_CONDITION,
  ignore_failure: false
};
const fieldOptions = {
  fieldKey: 'to',
  fieldHelpText: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.appendFieldHelpText', {
    defaultMessage: 'The field to append values to.'
  }),
  includeCondition: true,
  includeIgnoreFailures: true,
  includeIgnoreMissing: false
};
const fieldConfigurations = [{
  field: 'value',
  type: 'array',
  required: true,
  label: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.appendValueLabel', {
    defaultMessage: 'Values to append'
  }),
  helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.streams.streamDetailView.managementTab.enrichment.processor.appendValueHelpText",
    defaultMessage: "The values to append to the field.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 7
    }
  })
}, {
  field: 'allow_duplicates',
  type: 'boolean',
  required: false,
  label: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.appendAllowDuplicatesLabel', {
    defaultMessage: 'Allow duplicates'
  }),
  helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.streams.streamDetailView.managementTab.enrichment.processor.appendAllowDuplicatesHelpText",
    defaultMessage: "If false, the processor does not append values already present in the field.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 7
    }
  })
}];
const appendProcessorConfig = exports.appendProcessorConfig = {
  type: 'append',
  inputDisplay: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.appendInputDisplay', {
    defaultMessage: 'Append'
  }),
  getDocUrl: docLinks => {
    return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.streams.streamDetailView.managementTab.enrichment.processor.appendHelpText",
      defaultMessage: "{appendLink} Appends one or more values to an existing array if the field already exists and it is an array. Converts a scalar to an array and appends one or more values to it if the field exists and it is a scalar. Creates an array containing the provided values if the field doesn't exist.",
      values: {
        appendLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          "data-test-subj": "streamsAppAvailableProcessorsAppendLink",
          external: true,
          target: "_blank",
          href: docLinks.links.ingest.append,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 95,
            columnNumber: 13
          }
        }, _i18n.i18n.translate('xpack.streams.availableProcessors.appendLinkLabel', {
          defaultMessage: 'Appends values.'
        }))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 90,
        columnNumber: 7
      }
    });
  },
  defaultFormState,
  fieldConfigurations,
  fieldOptions,
  convertFormStateToConfig: (0, _utils.getConvertFormStateToConfig)(fieldConfigurations, fieldOptions),
  convertProcessorToFormState: (0, _utils.getConvertProcessorToFormState)(defaultFormState)
};