"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MemoPreviewTable = void 0;
exports.PreviewTable = PreviewTable;
exports.RowSelectionContext = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _utils = require("../stream_detail_enrichment/utils");
var _translations = require("../stream_detail_enrichment/data_sources_flyout/translations");
var _data_source_state_machine = require("../stream_detail_enrichment/state_management/data_source_state_machine");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/shared/preview_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const emptyCell = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, "\xA0");
const RowSelectionContext = exports.RowSelectionContext = /*#__PURE__*/(0, _react.createContext)({});
const useRowSelection = () => (0, _react.useContext)(RowSelectionContext);
function RowSelectionButton({
  rowIndex
}) {
  const {
    selectedRowIndex,
    onRowSelected
  } = useRowSelection();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    onClick: () => {
      if (onRowSelected) {
        onRowSelected(rowIndex);
      }
    },
    "aria-label": _i18n.i18n.translate('xpack.streams.resultPanel.euiDataGrid.preview.selectRowAriaLabel', {
      defaultMessage: 'Select row {rowIndex}',
      values: {
        rowIndex: rowIndex + 1
      }
    }),
    iconType: selectedRowIndex === rowIndex ? 'minimize' : 'expand',
    color: selectedRowIndex === rowIndex ? 'primary' : 'text',
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 5
    }
  });
}
const MemoPreviewTable = exports.MemoPreviewTable = /*#__PURE__*/_react.default.memo(PreviewTable);
function isDocumentWithIgnoredFields(doc) {
  return 'ignored_fields' in doc && Array.isArray(doc.ignored_fields);
}
function PreviewTable({
  documents,
  displayColumns,
  height,
  renderCellValue,
  rowHeightsOptions,
  sorting,
  setSorting,
  toolbarVisibility = false,
  setVisibleColumns,
  columnOrderHint = [],
  showRowSourceAvatars = false,
  showLeadingControlColumns = true,
  originalSamples,
  cellActions
}) {
  const {
    euiTheme: theme
  } = (0, _eui.useEuiTheme)();
  // Determine canonical column order
  const canonicalColumnOrder = (0, _react.useMemo)(() => {
    const cols = new Set();
    documents.forEach(doc => {
      const document = isDocumentWithIgnoredFields(doc) ? doc.values : doc;
      if (!document || typeof document !== 'object') {
        return;
      }
      Object.keys(document).forEach(key => {
        cols.add(key);
      });
    });
    let allColumns = Array.from(cols);

    // Sort columns by displayColumns or alphabetically as baseline
    allColumns = allColumns.sort((a, b) => {
      const indexA = (displayColumns || []).indexOf(a);
      const indexB = (displayColumns || []).indexOf(b);
      if (indexA === -1 && indexB === -1) {
        return a.localeCompare(b);
      }
      if (indexA === -1) return 1;
      if (indexB === -1) return -1;
      return indexA - indexB;
    });

    // Sort columns based on the columnOrderHint if provided
    if (columnOrderHint.length > 0) {
      const orderedCols = columnOrderHint.filter(col => allColumns.includes(col));
      const unorderedCols = allColumns.filter(col => !orderedCols.includes(col));
      allColumns = [...orderedCols, ...unorderedCols];
    }
    // Always show the displayColumns first, but preserve the order from allColumns
    if (displayColumns) {
      const displaySet = new Set(displayColumns);
      allColumns = [...allColumns.filter(col => displaySet.has(col)), ...allColumns.filter(col => !displaySet.has(col))];
    }
    return allColumns;
  }, [columnOrderHint, displayColumns, documents]);
  const sortingConfig = (0, _react.useMemo)(() => {
    if (!sorting && !setSorting) {
      return undefined;
    }
    return {
      columns: sorting !== null && sorting !== void 0 && sorting.fieldName ? [{
        id: (sorting === null || sorting === void 0 ? void 0 : sorting.fieldName) || '',
        direction: (sorting === null || sorting === void 0 ? void 0 : sorting.direction) || 'asc'
      }] : [],
      onSort: newSorting => {
        if (setSorting) {
          const mostRecentSorting = newSorting[newSorting.length - 1];
          setSorting({
            fieldName: mostRecentSorting === null || mostRecentSorting === void 0 ? void 0 : mostRecentSorting.id,
            direction: (mostRecentSorting === null || mostRecentSorting === void 0 ? void 0 : mostRecentSorting.direction) || 'asc'
          });
        }
      }
    };
  }, [setSorting, sorting]);
  const [columnWidths, setColumnWidths] = (0, _react.useState)({});
  const leadingControlColumns = (0, _react.useMemo)(() => [{
    id: 'selection',
    width: showRowSourceAvatars ? 72 : 36,
    headerCellRender: () => null,
    rowCellRender: ({
      rowIndex,
      setCellProps
    }) => {
      // eslint-disable-next-line react-hooks/rules-of-hooks
      const {
        selectedRowIndex
      } = useRowSelection();
      if (selectedRowIndex === rowIndex) {
        setCellProps({
          style: {
            backgroundColor: theme.colors.highlight
          }
        });
      } else {
        setCellProps({
          style: {}
        });
      }
      const originalSample = originalSamples === null || originalSamples === void 0 ? void 0 : originalSamples[rowIndex];
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "s",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 210,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(RowSelectionButton, {
        rowIndex: rowIndex,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 211,
          columnNumber: 15
        }
      }), showRowSourceAvatars && originalSample && /*#__PURE__*/_react.default.createElement(RowSourceAvatar, {
        originalSample: originalSample,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 213,
          columnNumber: 17
        }
      }));
    }
  }], [showRowSourceAvatars, originalSamples, theme.colors.highlight]);

  // Derive visibleColumns from canonical order
  const visibleColumns = (0, _react.useMemo)(() => {
    if (displayColumns) {
      return canonicalColumnOrder.filter(col => displayColumns.includes(col));
    }
    return canonicalColumnOrder;
  }, [canonicalColumnOrder, displayColumns]);
  const onColumnResize = (0, _react.useCallback)(({
    columnId,
    width
  }) => {
    setColumnWidths(prev => {
      const updated = (0, _utils.recalcColumnWidths)({
        columnId,
        width,
        prevWidths: prev,
        visibleColumns
      });
      return updated;
    });
  }, [visibleColumns]);
  const gridColumns = (0, _react.useMemo)(() => {
    return canonicalColumnOrder.map(column => ({
      id: column,
      displayAsText: column,
      actions: Boolean(setVisibleColumns) || Boolean(setSorting) ? {
        showHide: Boolean(setVisibleColumns),
        showMoveLeft: Boolean(setVisibleColumns),
        showMoveRight: Boolean(setVisibleColumns),
        showSortAsc: Boolean(setSorting),
        showSortDesc: Boolean(setSorting)
      } : false,
      initialWidth: columnWidths[column],
      cellActions
    }));
  }, [canonicalColumnOrder, setVisibleColumns, setSorting, columnWidths, cellActions]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiDataGrid, {
    "aria-label": _i18n.i18n.translate('xpack.streams.resultPanel.euiDataGrid.previewLabel', {
      defaultMessage: 'Preview'
    }),
    leadingControlColumns: showLeadingControlColumns && visibleColumns.length > 0 ? leadingControlColumns : undefined,
    columns: gridColumns,
    columnVisibility: {
      visibleColumns,
      setVisibleColumns: setVisibleColumns || (() => {}),
      canDragAndDropColumns: false
    },
    sorting: sortingConfig,
    inMemory: sortingConfig ? {
      level: 'sorting'
    } : undefined,
    height: height,
    toolbarVisibility: toolbarVisibility,
    rowCount: documents.length,
    rowHeightsOptions: rowHeightsOptions,
    onColumnResize: onColumnResize,
    renderCellValue: ({
      rowIndex,
      columnId,
      setCellProps
    }) => {
      // eslint-disable-next-line react-hooks/rules-of-hooks
      const {
        selectedRowIndex
      } = useRowSelection();
      if (selectedRowIndex === rowIndex) {
        setCellProps({
          style: {
            backgroundColor: theme.colors.highlight
          }
        });
      } else {
        setCellProps({
          style: {}
        });
      }
      const doc = documents[rowIndex];
      const document = isDocumentWithIgnoredFields(doc) ? doc.values : doc;
      const ignoredFields = isDocumentWithIgnoredFields(doc) ? doc.ignored_fields : [];
      if (!document || typeof document !== 'object') {
        return emptyCell;
      }
      if (renderCellValue) {
        const renderedValue = renderCellValue(document, columnId, ignoredFields);
        if (renderedValue !== undefined) {
          return renderedValue;
        }
      }
      const value = document[columnId];
      if (value === undefined || value === null) {
        return emptyCell;
      }
      if (typeof value === 'object') {
        return JSON.stringify(value);
      }
      return String(value) || emptyCell;
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 266,
      columnNumber: 5
    }
  });
}
function dataSourceTypeToI18nKey(type) {
  switch (type) {
    case 'random-samples':
      return 'randomSamples';
    case 'kql-samples':
      return 'kqlDataSource';
    case 'custom-samples':
      return 'customSamples';
  }
}
function RowSourceAvatar({
  originalSample
}) {
  const dataSourceContext = (0, _data_source_state_machine.useDataSourceSelectorById)(originalSample.dataSourceId, snapshot => snapshot === null || snapshot === void 0 ? void 0 : snapshot.context);
  if (!dataSourceContext) {
    // If the data source context is not available, we cannot render the avatar
    return null;
  }
  const {
    uiAttributes: {
      color
    },
    dataSource: {
      type: dataSourceType,
      name: rawDataSourceName
    }
  } = dataSourceContext;
  const name = rawDataSourceName || _translations.DATA_SOURCES_I18N[dataSourceTypeToI18nKey(dataSourceType)].placeholderName;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: name,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 357,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiAvatar, {
    size: "s",
    color: color,
    initialsLength: 1,
    name: name,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 358,
      columnNumber: 7
    }
  }));
}