"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.operatorOptions = exports.OperatorSelector = exports.BooleanShorthandOperatorKeys = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _streamlang = require("@kbn/streamlang");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/shared/operator_selector.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// UI-only shorthand operator keys for boolean literal comparisons ("equals true" etc.)
const BooleanShorthandOperatorKeys = exports.BooleanShorthandOperatorKeys = {
  EQ_TRUE: 'sh_eq_true',
  EQ_FALSE: 'sh_eq_false',
  NEQ_TRUE: 'sh_neq_true',
  NEQ_FALSE: 'sh_neq_false'
};
const streamlangOperators = Object.entries(_streamlang.operatorToHumanReadableNameMap).map(([value, text]) => ({
  value,
  text
}));
const streamlangEqualityOperators = streamlangOperators.filter(op => op.value === 'eq' || op.value === 'neq');
const streamlangNonEqualityOperators = streamlangOperators.filter(op => op.value !== 'eq' && op.value !== 'neq');
const operatorOptions = exports.operatorOptions = [...streamlangEqualityOperators,
// UI-only shorthand operators for boolean literals, not part of streamlang
{
  value: BooleanShorthandOperatorKeys.EQ_TRUE,
  text: _i18n.i18n.translate('xpack.streams.filter.equalsTrue', {
    defaultMessage: 'equals true'
  })
}, {
  value: BooleanShorthandOperatorKeys.EQ_FALSE,
  text: _i18n.i18n.translate('xpack.streams.filter.equalsFalse', {
    defaultMessage: 'equals false'
  })
}, {
  value: BooleanShorthandOperatorKeys.NEQ_TRUE,
  text: _i18n.i18n.translate('xpack.streams.filter.notEqualsTrue', {
    defaultMessage: 'not equals true'
  })
}, {
  value: BooleanShorthandOperatorKeys.NEQ_FALSE,
  text: _i18n.i18n.translate('xpack.streams.filter.notEqualsFalse', {
    defaultMessage: 'not equals false'
  })
}, ...streamlangNonEqualityOperators];
/**
 * Operator selector responsible for rendering the operator dropdown, including
 * UI-only shorthand options for boolean literals, and applying the appropriate
 * updates to the provided condition.
 */
const OperatorSelector = ({
  condition,
  onConditionChange,
  disabled = false,
  compressed = false,
  dataTestSubj = 'streamsAppConditionEditorOperator'
}) => {
  // Determine which operator should be displayed in the UI.
  const displayedOperator = (0, _react.useMemo)(() => {
    var _getBooleanShorthandO;
    // Check if a shorthand boolean operator can represent this condition
    return (_getBooleanShorthandO = getBooleanShorthandOperatorForFilterCondition(condition)) !== null && _getBooleanShorthandO !== void 0 ? _getBooleanShorthandO : (0, _streamlang.getFilterOperator)(condition);
  }, [condition]);
  const handleOperatorChange = (0, _react.useCallback)(event => {
    const newOperator = event.target.value;

    // Check if the condition is represented by a boolean shorthand operator, convert to equivalent if so
    const booleanShorthandCondition = getFilterConditionForBooleanShorthand(newOperator, condition.field);
    if (booleanShorthandCondition) {
      onConditionChange(booleanShorthandCondition);
      return;
    }
    const existingValue = (0, _streamlang.getFilterValue)(condition);
    const defaultValue = (0, _streamlang.getDefaultFormValueForOperator)(newOperator);
    const typeChanged = typeof existingValue !== typeof defaultValue;
    onConditionChange({
      field: condition.field,
      [newOperator]: existingValue !== undefined && !typeChanged ? existingValue : defaultValue
    });
  }, [condition, onConditionChange]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    "aria-label": _i18n.i18n.translate('xpack.streams.filter.operator', {
      defaultMessage: 'Operator'
    }),
    "data-test-subj": dataTestSubj,
    options: operatorOptions,
    value: displayedOperator,
    compressed: compressed,
    onChange: handleOperatorChange,
    disabled: disabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 5
    }
  });
};
exports.OperatorSelector = OperatorSelector;
function getBooleanShorthandOperatorForFilterCondition(condition) {
  const operator = (0, _streamlang.getFilterOperator)(condition);
  const value = (0, _streamlang.getFilterValue)(condition);
  if (operator === 'eq' && typeof value === 'boolean') {
    return value ? BooleanShorthandOperatorKeys.EQ_TRUE : BooleanShorthandOperatorKeys.EQ_FALSE;
  }
  if (operator === 'neq' && typeof value === 'boolean') {
    return value ? BooleanShorthandOperatorKeys.NEQ_TRUE : BooleanShorthandOperatorKeys.NEQ_FALSE;
  }
  return operator;
}

// Given a boolean shorthand operator and field, return the corresponding FilterCondition if applicable, or undefined
function getFilterConditionForBooleanShorthand(operator, field) {
  switch (operator) {
    case BooleanShorthandOperatorKeys.EQ_TRUE:
      return {
        field,
        eq: true
      };
    case BooleanShorthandOperatorKeys.EQ_FALSE:
      return {
        field,
        eq: false
      };
    case BooleanShorthandOperatorKeys.NEQ_TRUE:
      return {
        field,
        neq: true
      };
    case BooleanShorthandOperatorKeys.NEQ_FALSE:
      return {
        field,
        neq: false
      };
  }
  return undefined;
}