"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditableConditionPanel = exports.ConditionPanel = exports.ConditionDisplay = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _streamlang = require("@kbn/streamlang");
var _css = require("@emotion/css");
var _condition_editor = require("./condition_editor");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/shared/condition_display.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ConditionPanel = ({
  condition
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "subdued",
    paddingSize: "s",
    className: (0, _css.css)`
        border-radius: ${euiTheme.size.s};
      `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 28,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(ConditionDisplay, {
    condition: condition,
    showKeyword: true,
    keyword: "WHERE",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 7
    }
  }));
};
exports.ConditionPanel = ConditionPanel;
const EditableConditionPanel = ({
  condition,
  isEditingCondition,
  setCondition
}) => {
  return isEditingCondition ? /*#__PURE__*/_react.default.createElement(_condition_editor.ConditionEditor, {
    condition: condition,
    status: "enabled",
    onConditionChange: setCondition,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 5
    }
  }) : /*#__PURE__*/_react.default.createElement(ConditionPanel, {
    condition: condition,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 5
    }
  });
};
exports.EditableConditionPanel = EditableConditionPanel;
const ConditionDisplay = ({
  condition,
  showKeyword = false,
  keyword = 'WHERE'
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    wrap: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 5
    }
  }, showKeyword && /*#__PURE__*/_react.default.createElement(OperatorText, {
    operator: keyword,
    bold: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 23
    }
  }), /*#__PURE__*/_react.default.createElement(RecursiveConditionDisplay, {
    condition: condition,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 7
    }
  }));
};
exports.ConditionDisplay = ConditionDisplay;
const FilterBadges = ({
  condition
}) => {
  var _value$toString;
  const operator = (0, _streamlang.getFilterOperator)(condition);
  const value = (0, _streamlang.getFilterValue)(condition);
  const field = condition.field;
  const operatorText = _streamlang.operatorToHumanReadableNameMap[operator];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(BadgeItem, {
    text: field,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(OperatorText, {
    operator: operatorText,
    subdued: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(BadgeItem, {
    text: (_value$toString = value === null || value === void 0 ? void 0 : value.toString()) !== null && _value$toString !== void 0 ? _value$toString : '',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 7
    }
  }));
};
const BadgeItem = ({
  text
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 92,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
  color: "hollow",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 93,
    columnNumber: 5
  }
}, text));
const RecursiveConditionDisplay = ({
  condition,
  needsParentheses = false
}) => {
  const renderConditionsWithOperator = (conditions, operator) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, conditions.map((subCondition, index) => {
    // Only add parentheses when mixing different operator types
    const needsParens = operator === 'AND' && (0, _streamlang.isOrCondition)(subCondition) || operator === 'OR' && (0, _streamlang.isAndCondition)(subCondition);
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
      key: index,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 113,
        columnNumber: 11
      }
    }, index > 0 && /*#__PURE__*/_react.default.createElement(OperatorText, {
      operator: operator,
      bold: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 114,
        columnNumber: 27
      }
    }), /*#__PURE__*/_react.default.createElement(RecursiveConditionDisplay, {
      condition: subCondition,
      needsParentheses: needsParens,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 115,
        columnNumber: 13
      }
    }));
  }));
  const content = () => {
    if ((0, _streamlang.isAndCondition)(condition)) {
      return renderConditionsWithOperator(condition.and, 'AND');
    }
    if ((0, _streamlang.isOrCondition)(condition)) {
      return renderConditionsWithOperator(condition.or, 'OR');
    }
    if ((0, _streamlang.isNotCondition)(condition)) {
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(OperatorText, {
        operator: "NOT",
        bold: true,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 134,
          columnNumber: 11
        }
      }), /*#__PURE__*/_react.default.createElement(RecursiveConditionDisplay, {
        condition: condition.not,
        needsParentheses: (0, _streamlang.isAndCondition)(condition.not) || (0, _streamlang.isOrCondition)(condition.not),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 135,
          columnNumber: 11
        }
      }));
    }
    if ((0, _streamlang.isAlwaysCondition)(condition)) {
      return /*#__PURE__*/_react.default.createElement(BadgeItem, {
        text: "always",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 144,
          columnNumber: 14
        }
      });
    }
    if ((0, _streamlang.isNeverCondition)(condition)) {
      return /*#__PURE__*/_react.default.createElement(BadgeItem, {
        text: "never",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 148,
          columnNumber: 14
        }
      });
    }
    if ((0, _streamlang.isFilterConditionObject)(condition)) {
      return /*#__PURE__*/_react.default.createElement(FilterBadges, {
        condition: condition,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 152,
          columnNumber: 14
        }
      });
    }

    // Fallback for any unknown condition types
    return /*#__PURE__*/_react.default.createElement(BadgeItem, {
      text: JSON.stringify(condition),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 156,
        columnNumber: 12
      }
    });
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, needsParentheses && /*#__PURE__*/_react.default.createElement(OperatorText, {
    operator: "(",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 28
    }
  }), content(), needsParentheses && /*#__PURE__*/_react.default.createElement(OperatorText, {
    operator: ")",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 28
    }
  }));
};
const OperatorText = ({
  operator,
  bold,
  subdued
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 179,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: subdued ? 'subdued' : 'default',
    style: {
      fontWeight: bold ? euiTheme.font.weight.bold : euiTheme.font.weight.regular
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 180,
      columnNumber: 7
    }
  }, operator));
};