"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.typeSupportsFormat = exports.FieldFormFormat = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/schema_editor/flyout/field_form_format.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const POPULAR_FORMATS_SUGGESTIONS = [{
  label: 'strict_date_optional_time'
}, {
  label: 'date_optional_time'
}, {
  label: 'epoch_millis'
}, {
  label: 'basic_date_time'
}];
const typeSupportsFormat = type => {
  if (!type) return false;
  return ['date'].includes(type);
};
exports.typeSupportsFormat = typeSupportsFormat;
const FieldFormFormat = ({
  value,
  onChange
}) => {
  const selectedOptions = (0, _react.useMemo)(() => {
    if (!value) return [];
    const matchingSuggestion = POPULAR_FORMATS_SUGGESTIONS.find(suggestion => suggestion.label === value);
    return matchingSuggestion ? [matchingSuggestion] : [{
      label: value
    }];
  }, [value]);
  const handleSelectionChange = newSelectedOptions => {
    var _selectedOption$label;
    const selectedOption = newSelectedOptions[0];
    const newFieldValue = (_selectedOption$label = selectedOption === null || selectedOption === void 0 ? void 0 : selectedOption.label) !== null && _selectedOption$label !== void 0 ? _selectedOption$label : '';
    onChange(newFieldValue);
  };
  const handleCreateOption = searchValue => {
    const normalizedValue = searchValue.trim();
    if (normalizedValue) {
      handleSelectionChange([{
        label: normalizedValue
      }]);
    }
  };
  const placeholderText = _i18n.i18n.translate('xpack.streams.schemaEditor.fieldFormatSelector.placeholderText', {
    defaultMessage: 'Select or type the field format...'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    "data-test-subj": "streamsAppSchemaEditorFieldFormFormat",
    placeholder: placeholderText,
    "aria-label": placeholderText,
    options: POPULAR_FORMATS_SUGGESTIONS,
    selectedOptions: selectedOptions,
    onChange: handleSelectionChange,
    onCreateOption: handleCreateOption,
    singleSelection: {
      asPlainText: true
    },
    isClearable: true,
    fullWidth: true,
    customOptionText: _i18n.i18n.translate('xpack.streams.schemaEditor.fieldFormatSelector.customOptionText', {
      defaultMessage: 'Add {searchValue} as a custom format',
      values: {
        searchValue: '{searchValue}'
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 5
    }
  });
};
exports.FieldFormFormat = FieldFormFormat;