"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConditionMessage = ConditionMessage;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _streamlang = require("@kbn/streamlang");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/condition_message/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function ConditionMessage({
  condition
}) {
  if ((0, _streamlang.isAlwaysCondition)(condition) || (0, _streamlang.isNeverCondition)(condition)) {
    return '';
  }
  if ((0, _streamlang.isFilterCondition)(condition)) {
    return _i18n.i18n.translate('xpack.streams.filterDisplay.binary', {
      defaultMessage: '{field} {operator} {value}',
      values: {
        field: condition.field,
        operator: (0, _streamlang.getFilterOperator)(condition),
        value: String((0, _streamlang.getFilterValue)(condition))
      }
    });
  } else if ((0, _streamlang.isAndCondition)(condition)) {
    if (condition.and.length === 0) {
      return '';
    }
    if (condition.and.length === 1) {
      return /*#__PURE__*/_react.default.createElement(ConditionMessage, {
        condition: condition.and[0],
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 42,
          columnNumber: 14
        }
      });
    }
    return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.streams.andDisplay.andLabel",
      defaultMessage: "{left} AND {right}",
      values: {
        left: /*#__PURE__*/_react.default.createElement(ConditionMessage, {
          condition: condition.and[0],
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 49,
            columnNumber: 17
          }
        }),
        right: /*#__PURE__*/_react.default.createElement(ConditionMessage, {
          condition: {
            ...condition,
            and: condition.and.slice(1)
          },
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 51,
            columnNumber: 13
          }
        })
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 45,
        columnNumber: 7
      }
    });
  } else if ((0, _streamlang.isOrCondition)(condition)) {
    if (condition.or.length === 0) {
      return '';
    }
    if (condition.or.length === 1) {
      return /*#__PURE__*/_react.default.createElement(ConditionMessage, {
        condition: condition.or[0],
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 67,
          columnNumber: 14
        }
      });
    }
    return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.streams.orDisplay.orLabel",
      defaultMessage: "{left} OR {right}",
      values: {
        left: /*#__PURE__*/_react.default.createElement(ConditionMessage, {
          condition: condition.or[0],
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 74,
            columnNumber: 17
          }
        }),
        right: /*#__PURE__*/_react.default.createElement(ConditionMessage, {
          condition: {
            ...condition,
            or: condition.or.slice(1)
          },
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 76,
            columnNumber: 13
          }
        })
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 70,
        columnNumber: 7
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.streams.orDisplay.invalidConditionLabel",
    defaultMessage: "Invalid condition format",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 5
    }
  });
}