"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.streamlangWhereBlockSchema = exports.streamlangStepSchema = exports.streamlangDSLSchema = exports.isWhereBlockSchema = exports.isWhereBlock = exports.isActionBlockSchema = exports.isActionBlock = exports.conditionWithStepsSchema = void 0;
var _zod = require("@kbn/zod");
var _zodHelpers = require("@kbn/zod-helpers");
var _conditions = require("./conditions");
var _processors = require("./processors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Recursive schema for ConditionWithSteps
const conditionWithStepsSchema = exports.conditionWithStepsSchema = _zod.z.lazy(() => _zod.z.intersection(_conditions.conditionSchema, _zod.z.object({
  steps: _zod.z.array(streamlangStepSchema)
})));

/**
 * Nested where block (recursive)
 */

/**
 * Zod schema for a where block
 */
const streamlangWhereBlockSchema = exports.streamlangWhereBlockSchema = _zod.z.object({
  customIdentifier: _zod.z.string().optional(),
  where: conditionWithStepsSchema
});
const isWhereBlockSchema = obj => {
  return (0, _zodHelpers.isSchema)(streamlangWhereBlockSchema, obj);
};

// Cheap check that bypasses having to do full schema checks.
// This is useful for quickly identifying where blocks without full recursive validation.
exports.isWhereBlockSchema = isWhereBlockSchema;
const isWhereBlock = obj => {
  return 'where' in obj && !('action' in obj);
};

/**
 * A step can be either a processor or a where block (optionally recursive)
 */
exports.isWhereBlock = isWhereBlock;
const streamlangStepSchema = exports.streamlangStepSchema = _zod.z.lazy(() => _zod.z.union([_processors.streamlangProcessorSchema, streamlangWhereBlockSchema]));
const isActionBlockSchema = obj => {
  return (0, _zodHelpers.isSchema)(_processors.streamlangProcessorSchema, obj);
};

// Cheap check that bypasses having to do full schema checks.
// This is useful for quickly identifying action blocks without full recursive validation.
exports.isActionBlockSchema = isActionBlockSchema;
const isActionBlock = obj => {
  return obj !== undefined && 'action' in obj;
};

/**
 * Streamlang DSL Root Type
 */
exports.isActionBlock = isActionBlock;
/**
 * Zod schema for the Streamlang DSL root
 */
const streamlangDSLSchema = exports.streamlangDSLSchema = _zod.z.object({
  steps: _zod.z.array(streamlangStepSchema)
});