"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.commonIncidentSchemaObjectProperties = exports.PushToServiceIncidentSchema = exports.GetSeverityResponseSchema = exports.GetIncidentTypesResponseSchema = exports.GetIncidentResponseSchema = exports.GetCommonFieldsResponseSchema = exports.ExternalServiceIncidentResponseSchema = exports.ExternalServiceFieldsSchema = exports.ExternalIncidentServiceSecretConfigurationSchema = exports.ExternalIncidentServiceSecretConfiguration = exports.ExternalIncidentServiceConfigurationSchema = exports.ExternalIncidentServiceConfiguration = exports.ExecutorSubActionPushParamsSchema = exports.ExecutorSubActionGetSeverityParamsSchema = exports.ExecutorSubActionGetIncidentTypesParamsSchema = exports.ExecutorSubActionCommonFieldsParamsSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _validators = require("../lib/validators");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ExternalIncidentServiceConfiguration = exports.ExternalIncidentServiceConfiguration = {
  apiUrl: _configSchema.schema.string(),
  orgId: _configSchema.schema.string()
};
const ExternalIncidentServiceConfigurationSchema = exports.ExternalIncidentServiceConfigurationSchema = _configSchema.schema.object(ExternalIncidentServiceConfiguration);
const ExternalIncidentServiceSecretConfiguration = exports.ExternalIncidentServiceSecretConfiguration = {
  apiKeyId: _configSchema.schema.string(),
  apiKeySecret: _configSchema.schema.string()
};
const ExternalIncidentServiceSecretConfigurationSchema = exports.ExternalIncidentServiceSecretConfigurationSchema = _configSchema.schema.object(ExternalIncidentServiceSecretConfiguration);
const MAX_ADDITIONAL_FIELDS_LENGTH = 50;
const AdditionalFields = {
  additionalFields: _configSchema.schema.nullable(_configSchema.schema.recordOf(_configSchema.schema.string({
    validate: value => validateOtherFieldsKeys(value)
  }), _configSchema.schema.any(), {
    validate: value => (0, _validators.validateRecordMaxKeys)({
      record: value,
      maxNumberOfFields: MAX_ADDITIONAL_FIELDS_LENGTH,
      fieldName: 'additionalFields'
    })
  }))
};
const CommonIncidentAttributes = {
  name: _configSchema.schema.string(),
  description: _configSchema.schema.nullable(_configSchema.schema.string()),
  externalId: _configSchema.schema.nullable(_configSchema.schema.string()),
  incidentTypes: _configSchema.schema.nullable(_configSchema.schema.arrayOf(_configSchema.schema.number())),
  severityCode: _configSchema.schema.nullable(_configSchema.schema.number()),
  ...AdditionalFields
};
const commonIncidentSchemaObjectProperties = exports.commonIncidentSchemaObjectProperties = Object.keys(CommonIncidentAttributes);
const validateOtherFieldsKeys = key => {
  return (0, _validators.validateKeysAllowed)({
    key,
    disallowList: commonIncidentSchemaObjectProperties,
    fieldName: 'additionalFields'
  });
};
const ExecutorSubActionPushParamsSchema = exports.ExecutorSubActionPushParamsSchema = _configSchema.schema.object({
  incident: _configSchema.schema.object({
    ...CommonIncidentAttributes
  }),
  comments: _configSchema.schema.nullable(_configSchema.schema.arrayOf(_configSchema.schema.object({
    comment: _configSchema.schema.string(),
    commentId: _configSchema.schema.string()
  })))
});
const PushToServiceIncidentSchema = exports.PushToServiceIncidentSchema = {
  name: _configSchema.schema.string(),
  description: _configSchema.schema.nullable(_configSchema.schema.string()),
  incidentTypes: _configSchema.schema.nullable(_configSchema.schema.arrayOf(_configSchema.schema.number())),
  severityCode: _configSchema.schema.nullable(_configSchema.schema.number()),
  ...AdditionalFields
};

// Reserved for future implementation
const ExecutorSubActionCommonFieldsParamsSchema = exports.ExecutorSubActionCommonFieldsParamsSchema = _configSchema.schema.object({});
const ExecutorSubActionGetIncidentTypesParamsSchema = exports.ExecutorSubActionGetIncidentTypesParamsSchema = _configSchema.schema.object({});
const ExecutorSubActionGetSeverityParamsSchema = exports.ExecutorSubActionGetSeverityParamsSchema = _configSchema.schema.object({});
const ArrayOfValuesSchema = _configSchema.schema.arrayOf(_configSchema.schema.object({
  value: _configSchema.schema.number(),
  label: _configSchema.schema.string()
}, {
  unknowns: 'allow'
}));
const GetIncidentTypesResponseSchema = exports.GetIncidentTypesResponseSchema = _configSchema.schema.object({
  values: ArrayOfValuesSchema
}, {
  unknowns: 'allow'
});
const GetSeverityResponseSchema = exports.GetSeverityResponseSchema = _configSchema.schema.object({
  values: ArrayOfValuesSchema
}, {
  unknowns: 'allow'
});
const ValuesItemSchema = _configSchema.schema.object({
  value: _configSchema.schema.oneOf([_configSchema.schema.number(), _configSchema.schema.string()]),
  label: _configSchema.schema.string(),
  enabled: _configSchema.schema.boolean(),
  hidden: _configSchema.schema.boolean(),
  default: _configSchema.schema.boolean()
}, {
  unknowns: 'allow'
});
const ExternalServiceFieldsSchema = exports.ExternalServiceFieldsSchema = _configSchema.schema.object({
  input_type: _configSchema.schema.string(),
  name: _configSchema.schema.string(),
  read_only: _configSchema.schema.boolean(),
  required: _configSchema.schema.nullable(_configSchema.schema.string()),
  text: _configSchema.schema.string(),
  prefix: _configSchema.schema.nullable(_configSchema.schema.string()),
  values: _configSchema.schema.nullable(_configSchema.schema.arrayOf(ValuesItemSchema))
}, {
  unknowns: 'allow'
});
const GetCommonFieldsResponseSchema = exports.GetCommonFieldsResponseSchema = _configSchema.schema.arrayOf(ExternalServiceFieldsSchema);
const ExternalServiceIncidentResponseSchema = exports.ExternalServiceIncidentResponseSchema = _configSchema.schema.object({
  id: _configSchema.schema.string(),
  title: _configSchema.schema.string(),
  url: _configSchema.schema.string(),
  pushedDate: _configSchema.schema.string()
});
const GetIncidentResponseSchema = exports.GetIncidentResponseSchema = _configSchema.schema.object({
  id: _configSchema.schema.number(),
  inc_last_modified_date: _configSchema.schema.number()
}, {
  unknowns: 'allow'
});