"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "JIRA_SERVICE_MANAGEMENT_CONNECTOR_TYPE_ID", {
  enumerable: true,
  get: function () {
    return _constants.JIRA_SERVICE_MANAGEMENT_CONNECTOR_TYPE_ID;
  }
});
exports.getJiraServiceManagementConnectorType = void 0;
var _common = require("@kbn/actions-plugin/common");
var _server = require("@kbn/actions-plugin/server");
var _types = require("@kbn/actions-plugin/server/sub_action_framework/types");
var _constants = require("../../../common/jira-service-management/constants");
var _connector = require("./connector");
var _schema = require("./schema");
var i18n = _interopRequireWildcard(require("./translations"));
var _render_template_variables = require("./render_template_variables");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getJiraServiceManagementConnectorType = () => {
  return {
    getService: params => new _connector.JiraServiceManagementConnector(params),
    minimumLicenseRequired: 'platinum',
    name: i18n.JIRA_SERVICE_MANAGEMENT_NAME,
    id: _constants.JIRA_SERVICE_MANAGEMENT_CONNECTOR_TYPE_ID,
    schema: {
      config: _schema.ConfigSchema,
      secrets: _schema.SecretsSchema
    },
    validators: [{
      type: _types.ValidatorType.CONFIG,
      validator: (0, _server.urlAllowListValidator)('apiUrl')
    }],
    supportedFeatureIds: [_common.AlertingConnectorFeatureId, _common.UptimeConnectorFeatureId, _common.SecurityConnectorFeatureId],
    renderParameterTemplates: _render_template_variables.renderParameterTemplates
  };
};
exports.getJiraServiceManagementConnectorType = getJiraServiceManagementConnectorType;