"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.D3SecurityConnector = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _server = require("@kbn/actions-plugin/server");
var _helpers = require("./helpers");
var _schema = require("../../../common/d3security/schema");
var _constants = require("../../../common/d3security/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class D3SecurityConnector extends _server.SubActionConnector {
  constructor(params) {
    super(params);
    (0, _defineProperty2.default)(this, "url", void 0);
    (0, _defineProperty2.default)(this, "token", void 0);
    this.url = this.config.url;
    this.token = this.secrets.token;
    this.registerSubActions();
  }
  registerSubActions() {
    this.registerSubAction({
      name: _constants.SUB_ACTION.RUN,
      method: 'runApi',
      schema: _schema.D3SecurityRunActionParamsSchema
    });
    this.registerSubAction({
      name: _constants.SUB_ACTION.TEST,
      method: 'runApi',
      schema: _schema.D3SecurityRunActionParamsSchema
    });
  }
  getResponseErrorMessage(error) {
    var _error$response, _error$response2, _error$response3;
    if (!((_error$response = error.response) !== null && _error$response !== void 0 && _error$response.status)) {
      return 'Unknown API Error';
    }
    if (error.response.status === 401) {
      return 'Unauthorized API Error';
    }
    return `API Error: ${(_error$response2 = error.response) === null || _error$response2 === void 0 ? void 0 : _error$response2.status} - ${(_error$response3 = error.response) === null || _error$response3 === void 0 ? void 0 : _error$response3.statusText}`;
  }
  async runApi({
    body,
    severity,
    eventType
  }, connectorUsageCollector) {
    const response = await this.request({
      url: this.url,
      method: 'post',
      responseSchema: _schema.D3SecurityRunActionResponseSchema,
      data: (0, _helpers.addSeverityAndEventTypeInBody)(body !== null && body !== void 0 ? body : '', severity !== null && severity !== void 0 ? severity : _constants.D3SecuritySeverity.EMPTY, eventType !== null && eventType !== void 0 ? eventType : ''),
      headers: {
        d3key: this.token || ''
      }
    }, connectorUsageCollector);
    return response.data;
  }
}
exports.D3SecurityConnector = D3SecurityConnector;