"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WEB_API = exports.TOKEN_LABEL = exports.SUCCESS_FETCH_CHANNELS = exports.SELECT_MESSAGE = exports.MESSAGE_REQUIRED = exports.JSON_REQUIRED = exports.ERROR_VALID_CHANNELS = exports.ERROR_INVALID_CHANNELS = exports.CHANNEL_REQUIRED = exports.BLOCKS_REQUIRED = exports.ALLOWED_CHANNELS = exports.ACTION_TYPE_TITLE = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MESSAGE_REQUIRED = exports.MESSAGE_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.slack_api.error.requiredSlackMessageText', {
  defaultMessage: 'Message is required.'
});
const CHANNEL_REQUIRED = exports.CHANNEL_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.slack_api.error.requiredSlackChannel', {
  defaultMessage: 'Channel ID is required.'
});
const TOKEN_LABEL = exports.TOKEN_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.slack_api.tokenTextFieldLabel', {
  defaultMessage: 'API Token'
});
const WEB_API = exports.WEB_API = _i18n.i18n.translate('xpack.stackConnectors.components.slack_api.webApi', {
  defaultMessage: 'Web API'
});
const SELECT_MESSAGE = exports.SELECT_MESSAGE = _i18n.i18n.translate('xpack.stackConnectors.components.slack_api.selectMessageText', {
  defaultMessage: 'Send messages to Slack channels.'
});
const ACTION_TYPE_TITLE = exports.ACTION_TYPE_TITLE = _i18n.i18n.translate('xpack.stackConnectors.components.slack_api.connectorTypeTitle', {
  defaultMessage: 'Slack'
});
const ALLOWED_CHANNELS = exports.ALLOWED_CHANNELS = _i18n.i18n.translate('xpack.stackConnectors.components.slack_api.allowedChannelsLabel', {
  defaultMessage: 'Channel IDs'
});
const SUCCESS_FETCH_CHANNELS = exports.SUCCESS_FETCH_CHANNELS = _i18n.i18n.translate('xpack.stackConnectors.components.slack_api.successFetchChannelsText', {
  defaultMessage: 'Fetch all channels'
});
const ERROR_VALID_CHANNELS = exports.ERROR_VALID_CHANNELS = _i18n.i18n.translate('xpack.stackConnectors.components.slack_api.errorValidChannelsText', {
  defaultMessage: 'Cannot valid channels, please check the validity of your token or your channel'
});
const ERROR_INVALID_CHANNELS = invalidChannels => _i18n.i18n.translate('xpack.stackConnectors.components.slack_api.errorInvalidChannelsText', {
  defaultMessage: 'Cannot validate channel ID "{channels}", please check the validity of your token and/or the channel ID',
  values: {
    channels: invalidChannels.join(', ')
  }
});
exports.ERROR_INVALID_CHANNELS = ERROR_INVALID_CHANNELS;
const JSON_REQUIRED = exports.JSON_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.slack_api.error.slackBlockkitJsonRequired', {
  defaultMessage: 'Block kit must be valid JSON.'
});
const BLOCKS_REQUIRED = exports.BLOCKS_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.slack_api.error.slackBlockkitBlockRequired', {
  defaultMessage: `JSON must contain field "blocks".`
});