"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CredentialsApiUrl = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _helpers = require("@kbn/es-ui-shared-plugin/static/forms/helpers");
var _components = require("@kbn/es-ui-shared-plugin/static/forms/components");
var _public = require("@kbn/triggers-actions-ui-plugin/public");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/stack_connectors/public/connector_types/lib/servicenow/credentials_api_url.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const {
  urlField
} = _helpers.fieldValidators;
const CredentialsApiUrlComponent = ({
  isLoading,
  readOnly,
  pathPrefix = ''
}) => {
  const {
    docLinks
  } = (0, _public.useKibana)().services;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.stackConnectors.components.serviceNow.apiUrlHelpLabel",
    defaultMessage: "Provide the full URL to the desired ServiceNow instance. If you don't have one, {instance}.",
    values: {
      instance: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: docLinks.links.alerting.serviceNowAction,
        target: "_blank",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 38,
          columnNumber: 17
        }
      }, i18n.SETUP_DEV_INSTANCE)
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 33,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: `${pathPrefix}config.apiUrl`,
    component: _components.TextField,
    config: {
      label: i18n.API_URL_LABEL,
      validations: [{
        validator: urlField(i18n.API_URL_INVALID)
      }]
    },
    componentProps: {
      euiFieldProps: {
        'data-test-subj': 'credentialsApiUrlFromInput',
        isLoading,
        readOnly,
        disabled: readOnly || isLoading
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 7
    }
  }));
};
const CredentialsApiUrl = exports.CredentialsApiUrl = /*#__PURE__*/(0, _react.memo)(CredentialsApiUrlComponent);