"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/triggers-actions-ui-plugin/public");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _constants = require("./constants");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/stack_connectors/public/connector_types/jira-service-management/connector_params.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const configFormSchema = [{
  id: 'apiUrl',
  label: i18n.API_URL_LABEL,
  isUrlField: true,
  defaultValue: _constants.DEFAULT_URL,
  helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "The Jira Service Management API base URL.",
    id: "xpack.stackConnectors.components.jiraServiceManagement.apiUrlDescription",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 27,
      columnNumber: 7
    }
  })
}];
const secretsFormSchema = [{
  id: 'apiKey',
  label: i18n.API_KEY_LABEL,
  isPasswordField: true,
  helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "The JSM API authentication key for HTTP Basic authentication. For more details about generating JSM integration API keys, refer to the {jsmAPIKeyDocs}.",
    id: "xpack.stackConnectors.components.jiraServiceManagement.apiKeyDocumentation",
    values: {
      jsmAPIKeyDocs: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: "https://support.atlassian.com/jira-service-management-cloud/docs/set-up-an-api-integration/#Set-up-the-integration",
        target: "_blank",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 46,
          columnNumber: 13
        }
      }, i18n.JIRA_SERVICE_MANAGEMENT_DOCUMENTATION)
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 7
    }
  })
}];
const JiraServiceManagementConnectorParams = ({
  readOnly,
  isEdit
}) => {
  return /*#__PURE__*/_react.default.createElement(_public.SimpleConnectorForm, {
    isEdit: isEdit,
    readOnly: readOnly,
    configFormSchema: configFormSchema,
    secretsFormSchema: secretsFormSchema,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 5
    }
  });
};

// eslint-disable-next-line import/no-default-export
exports.default = JiraServiceManagementConnectorParams;
module.exports = exports.default;