"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateStep = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _components = require("@kbn/es-ui-shared-plugin/static/forms/components");
var _helpers = require("@kbn/es-ui-shared-plugin/static/forms/helpers");
var _public = require("@kbn/triggers-actions-ui-plugin/public");
var _validator = require("../validator");
var _action_variables = require("../action_variables");
var _webhook_connectors = require("../webhook_connectors");
var i18n = _interopRequireWildcard(require("../translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/stack_connectors/public/connector_types/cases_webhook/steps/create.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const {
  emptyField,
  urlField
} = _helpers.fieldValidators;
const CreateStep = ({
  display,
  readOnly
}) => /*#__PURE__*/_react.default.createElement("span", {
  "data-test-subj": "createStep",
  style: {
    display: display ? 'block' : 'none'
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 27,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 28,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement("h3", {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 29,
    columnNumber: 7
  }
}, i18n.STEP_2), /*#__PURE__*/_react.default.createElement("small", {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 30,
    columnNumber: 7
  }
}, /*#__PURE__*/_react.default.createElement("p", {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 31,
    columnNumber: 9
  }
}, i18n.STEP_2_DESCRIPTION))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "s",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 34,
    columnNumber: 5
  }
}), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  justifyContent: "spaceBetween",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 35,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 36,
    columnNumber: 7
  }
}, /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
  path: "config.createIncidentMethod",
  component: _components.Field,
  config: {
    label: i18n.CREATE_INCIDENT_METHOD,
    defaultValue: 'post',
    type: _hook_form_lib.FIELD_TYPES.SELECT,
    validations: [{
      validator: emptyField(i18n.CREATE_METHOD_REQUIRED)
    }]
  },
  componentProps: {
    euiFieldProps: {
      'data-test-subj': 'webhookCreateMethodSelect',
      options: _webhook_connectors.HTTP_VERBS.map(verb => ({
        text: verb.toUpperCase(),
        value: verb
      })),
      readOnly
    }
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 37,
    columnNumber: 9
  }
})), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 59,
    columnNumber: 7
  }
}, /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
  path: "config.createIncidentUrl",
  config: {
    label: i18n.CREATE_INCIDENT_URL,
    validations: [{
      validator: urlField(i18n.CREATE_URL_REQUIRED)
    }]
  },
  component: _components.Field,
  componentProps: {
    euiFieldProps: {
      readOnly,
      'data-test-subj': 'webhookCreateUrlText'
    }
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 60,
    columnNumber: 9
  }
}))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 80,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 81,
    columnNumber: 7
  }
}, /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
  path: "config.createIncidentJson",
  config: {
    helpText: i18n.CREATE_INCIDENT_JSON_HELP,
    label: i18n.CREATE_INCIDENT_JSON,
    validations: [{
      validator: emptyField(i18n.CREATE_INCIDENT_REQUIRED)
    }, {
      validator: (0, _validator.containsTitleAndDesc)()
    }]
  },
  component: _public.JsonFieldWrapper,
  componentProps: {
    euiCodeEditorProps: {
      isReadOnly: readOnly,
      ['aria-label']: i18n.CODE_EDITOR
    },
    dataTestSubj: 'webhookCreateIncidentJson',
    messageVariables: _action_variables.casesVars,
    paramsProperty: 'createIncidentJson',
    buttonTitle: i18n.ADD_CASES_VARIABLE,
    showButtonTitle: true
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 82,
    columnNumber: 9
  }
}))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 111,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 112,
    columnNumber: 7
  }
}, /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
  path: "config.createIncidentResponseKey",
  config: {
    helpText: i18n.CREATE_INCIDENT_RESPONSE_KEY_HELP,
    label: i18n.CREATE_INCIDENT_RESPONSE_KEY,
    validations: [{
      validator: emptyField(i18n.CREATE_RESPONSE_KEY_REQUIRED)
    }]
  },
  component: _components.Field,
  componentProps: {
    euiFieldProps: {
      readOnly,
      'data-test-subj': 'createIncidentResponseKeyText'
    }
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 113,
    columnNumber: 9
  }
}))));
exports.CreateStep = CreateStep;