"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.QueryInput = void 0;
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _esQuery = require("@kbn/es-query");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/stack_alerts/public/rule_types/geo_containment/rule_form/query_input.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function validateQuery(query) {
  try {
    // eslint-disable-next-line @typescript-eslint/no-unused-expressions
    query.language === 'kuery' ? (0, _esQuery.fromKueryExpression)(query.query) : (0, _esQuery.luceneStringToDsl)(query.query);
  } catch (err) {
    return false;
  }
  return true;
}
const QueryInput = props => {
  const {
    unifiedSearch: {
      ui: {
        QueryStringInput
      }
    }
  } = (0, _public.useKibana)().services;
  const [localQuery, setLocalQuery] = (0, _react.useState)(props.query || {
    query: '',
    language: 'kuery'
  });
  return /*#__PURE__*/_react.default.createElement(QueryStringInput, {
    disableAutoFocus: true,
    bubbleSubmitEvent: true,
    indexPatterns: props.dataView ? [props.dataView] : [],
    query: localQuery,
    onChange: query => {
      if (query.language) {
        setLocalQuery(query);
        if (validateQuery(query)) {
          props.onChange(query);
        }
      }
    },
    appName: _ruleDataUtils.STACK_ALERTS_FEATURE_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 5
    }
  });
};
exports.QueryInput = QueryInput;