"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BoundaryForm = exports.BOUNDARY_GEO_FIELD_TYPES = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _data_view_select = require("./data_view_select");
var _single_field_select = require("./single_field_select");
var _query_input = require("./query_input");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/stack_alerts/public/rule_types/geo_containment/rule_form/boundary_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const BOUNDARY_GEO_FIELD_TYPES = exports.BOUNDARY_GEO_FIELD_TYPES = ['geo_shape'];
function getGeoFields(fields) {
  return fields.filter(field => BOUNDARY_GEO_FIELD_TYPES.includes(field.type));
}
function getNameFields(fields) {
  return fields.filter(field => ['string', 'number', 'ip'].includes(field.type) && !field.name.startsWith('_') && !field.name.endsWith('keyword'));
}
const BoundaryForm = props => {
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const [dataView, setDataView] = (0, _react.useState)();
  const [dataViewNotFound, setDataViewNotFound] = (0, _react.useState)(false);
  const [geoFields, setGeoFields] = (0, _react.useState)([]);
  const [nameFields, setNameFields] = (0, _react.useState)([]);
  (0, _react.useEffect)(() => {
    if (!props.ruleParams.boundaryIndexId || props.ruleParams.boundaryIndexId === (dataView === null || dataView === void 0 ? void 0 : dataView.id)) {
      return;
    }
    let ignore = false;
    setIsLoading(true);
    setDataViewNotFound(false);
    props.data.indexPatterns.get(props.ruleParams.boundaryIndexId).then(nextDataView => {
      if (!ignore) {
        setDataView(nextDataView);
        setGeoFields(getGeoFields(nextDataView.fields));
        setNameFields(getNameFields(nextDataView.fields));
        setIsLoading(false);
      }
    }).catch(() => {
      if (!ignore) {
        setDataViewNotFound(true);
        setIsLoading(false);
      }
    });
    return () => {
      ignore = true;
    };
  }, [props.ruleParams.boundaryIndexId, dataView === null || dataView === void 0 ? void 0 : dataView.id, props.data.indexPatterns]);
  function getDataViewError() {
    const validationError = props.getValidationError('boundaryIndexTitle');
    if (validationError) {
      return validationError;
    }
    if (dataView && geoFields.length === 0) {
      return _i18n.i18n.translate('xpack.stackAlerts.geoContainment.noGeoFieldInIndexPattern.message', {
        defaultMessage: 'Data view does not contain geospatial fields. Must have one of type: {geoFieldTypes}.',
        values: {
          geoFieldTypes: BOUNDARY_GEO_FIELD_TYPES.join(', ')
        }
      });
    }
    if (dataViewNotFound) {
      return _i18n.i18n.translate('xpack.stackAlerts.geoContainment.dataViewNotFound', {
        defaultMessage: `Unable to find data view ''{id}''`,
        values: {
          id: props.ruleParams.indexId
        }
      });
    }
    return null;
  }
  const dataViewError = getDataViewError();
  const geoFieldError = props.getValidationError('boundaryGeoField');
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h5", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.stackAlerts.geoContainment.boundariesFormLabel",
    defaultMessage: "Boundaries",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    lines: 3,
    size: "s",
    isLoading: isLoading,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    error: dataViewError,
    isInvalid: Boolean(dataViewError),
    label: _i18n.i18n.translate('xpack.stackAlerts.geoContainment.dataViewLabel', {
      defaultMessage: 'Data view'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_data_view_select.DataViewSelect, {
    dataViewId: props.ruleParams.boundaryIndexId,
    data: props.data,
    isInvalid: Boolean(dataViewError),
    onChange: nextDataView => {
      if (!nextDataView.id) {
        return;
      }
      props.setDataViewId(nextDataView.id);
      props.setDataViewTitle(nextDataView.title);
      const nextGeoFields = getGeoFields(nextDataView.fields);
      if (nextGeoFields.length) {
        props.setGeoField(nextGeoFields[0].name);
      } else if ('boundaryGeoField' in props.ruleParams) {
        props.setGeoField('');
      }

      // do not attempt to auto select name field
      // its optional plus there can be many matches so auto selecting the correct field is improbable
      if ('boundaryNameField' in props.ruleParams) {
        props.setNameField(undefined);
      }
    },
    unifiedSearch: props.unifiedSearch,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 11
    }
  })), props.ruleParams.boundaryIndexId && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    error: geoFieldError,
    isInvalid: Boolean(geoFieldError),
    label: _i18n.i18n.translate('xpack.stackAlerts.geoContainment.geofieldLabel', {
      defaultMessage: 'Location'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_single_field_select.SingleFieldSelect, {
    isInvalid: Boolean(geoFieldError),
    placeholder: _i18n.i18n.translate('xpack.stackAlerts.geoContainment.selectGeoLabel', {
      defaultMessage: 'Select location field'
    }),
    value: props.ruleParams.boundaryGeoField,
    onChange: fieldName => {
      if (fieldName) {
        props.setGeoField(fieldName);
      }
    },
    fields: geoFields,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 172,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.stackAlerts.geoContainment.boundaryNameSelectLabel', {
      defaultMessage: 'Display name (optional)'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 187,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_single_field_select.SingleFieldSelect, {
    placeholder: _i18n.i18n.translate('xpack.stackAlerts.geoContainment.selectBoundaryNameLabel', {
      defaultMessage: 'Select name field'
    }),
    value: props.ruleParams.boundaryNameField,
    onChange: fieldName => {
      if (fieldName) {
        props.setNameField(fieldName);
      }
    },
    fields: nameFields,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 192,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    helpText: _i18n.i18n.translate('xpack.stackAlerts.geoContainment.boundariesFilterHelpText', {
      defaultMessage: 'Add a filter to narrow boundaries.'
    }),
    label: _i18n.i18n.translate('xpack.stackAlerts.geoContainment.filterLabel', {
      defaultMessage: 'Filter'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 209,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_query_input.QueryInput, {
    dataView: dataView,
    onChange: query => {
      props.setQuery(query);
    },
    query: props.ruleParams.boundaryIndexQuery,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 220,
      columnNumber: 15
    }
  })))));
};
exports.BoundaryForm = BoundaryForm;