"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SpaceTable = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _common = require("../../../common");
var _space_avatar = require("../../space_avatar");
var _space_solution_badge = require("../../space_solution_badge");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/spaces/public/space_selector/components/space_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// Lazy load the space avatar component
const LazySpaceAvatar = /*#__PURE__*/(0, _react.lazy)(() => (0, _space_avatar.getSpaceAvatarComponent)().then(component => ({
  default: component
})));
class SpaceTable extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "onTableChange", ({
      page,
      sort
    }) => {
      if (page) {
        this.setState({
          pageIndex: page.index,
          pageSize: page.size
        });
      }
      if (sort) {
        this.setState({
          sortField: sort.field,
          sortDirection: sort.direction
        });
      }
    });
    (0, _defineProperty2.default)(this, "renderSpaceAvatar", space => {
      return /*#__PURE__*/_react.default.createElement(_react.Suspense, {
        fallback: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
          size: "s",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 72,
            columnNumber: 27
          }
        }),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 72,
          columnNumber: 7
        }
      }, /*#__PURE__*/_react.default.createElement(LazySpaceAvatar, {
        space: space,
        size: "s",
        announceSpaceName: false,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 73,
          columnNumber: 9
        }
      }));
    });
    (0, _defineProperty2.default)(this, "renderSpaceName", space => {
      const spaceUrl = (0, _common.addSpaceIdToPath)(this.props.serverBasePath, space.id, _common.ENTER_SPACE_PATH);
      return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: spaceUrl,
        "data-test-subj": `space-link-${space.id}`,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 82,
          columnNumber: 7
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 83,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement("strong", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 84,
          columnNumber: 11
        }
      }, space.name)));
    });
    (0, _defineProperty2.default)(this, "renderSpaceDescription", space => {
      const description = space.description || '';
      if (!description) {
        return null;
      }

      // Use simple text display like the working card view
      return /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
        color: "subdued",
        className: "eui-textBreakWord",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 99,
          columnNumber: 7
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 100,
          columnNumber: 9
        }
      }, description));
    });
    (0, _defineProperty2.default)(this, "renderSpaceSolution", space => {
      if (!space.solution) {
        return null;
      }
      return /*#__PURE__*/_react.default.createElement(_space_solution_badge.SpaceSolutionBadge, {
        solution: space.solution,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 110,
          columnNumber: 12
        }
      });
    });
    this.state = {
      pageIndex: 0,
      pageSize: 10,
      sortField: 'name',
      sortDirection: 'asc'
    };
  }
  render() {
    const {
      spaces,
      loading
    } = this.props;
    const {
      pageIndex,
      pageSize,
      sortField,
      sortDirection
    } = this.state;

    // Sort spaces
    const sortedSpaces = spaces.slice().sort((a, b) => {
      if (!sortField) return 0;
      const aValue = String(a[sortField] || '');
      const bValue = String(b[sortField] || '');
      const comparison = aValue.localeCompare(bValue);
      return sortDirection === 'desc' ? -comparison : comparison;
    });

    // Paginate spaces
    const startIndex = pageIndex * pageSize;
    const paginatedSpaces = sortedSpaces.slice(startIndex, startIndex + pageSize);
    const columns = [{
      field: 'name',
      name: '',
      width: '48px',
      render: (name, space) => this.renderSpaceAvatar(space)
    }, {
      field: 'name',
      name: _i18n.i18n.translate('xpack.spaces.spaceTable.nameColumnTitle', {
        defaultMessage: 'Name'
      }),
      sortable: true,
      render: (name, space) => this.renderSpaceName(space),
      width: '30%'
    }, {
      field: 'description',
      name: _i18n.i18n.translate('xpack.spaces.spaceTable.descriptionColumnTitle', {
        defaultMessage: 'Description'
      }),
      render: (description, space) => this.renderSpaceDescription(space),
      width: '45%'
    }, {
      field: 'solution',
      name: _i18n.i18n.translate('xpack.spaces.spaceTable.solutionColumnTitle', {
        defaultMessage: 'Solution'
      }),
      render: (solution, space) => this.renderSpaceSolution(space),
      width: '180px'
    }];
    const pagination = {
      pageIndex,
      pageSize,
      totalItemCount: spaces.length,
      pageSizeOptions: [10, 25, 50, 100]
    };
    const sorting = {
      sort: sortField && sortDirection ? {
        field: sortField,
        direction: sortDirection
      } : undefined
    };
    return /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
      tableCaption: _i18n.i18n.translate('xpack.spaces.spaceTable.tableCaption', {
        defaultMessage: 'Available spaces'
      }),
      items: paginatedSpaces,
      columns: columns,
      pagination: pagination,
      sorting: sorting,
      onChange: this.onTableChange,
      loading: loading,
      "data-test-subj": "spacesTable",
      rowProps: space => ({
        'data-test-subj': `space-table-row-${space.id}`
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 184,
        columnNumber: 7
      }
    });
  }
}
exports.SpaceTable = SpaceTable;