"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initSpacesNavControl = initSpacesNavControl;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _react2 = _interopRequireWildcard(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _reactQuery = require("@kbn/react-query");
var _uiTheme = require("@kbn/ui-theme");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/spaces/public/nav_control/nav_control.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function initSpacesNavControl(spacesManager, core, config, eventTracker, tour) {
  const queryClient = new _reactQuery.QueryClient({
    defaultOptions: {
      queries: {
        staleTime: 0,
        networkMode: 'always'
      }
    }
  });
  core.chrome.navControls.registerLeft({
    order: 1000,
    mount(targetDomElement) {
      if (core.http.anonymousPaths.isAnonymous(window.location.pathname)) {
        return () => null;
      }
      const LazyNavControlPopover = /*#__PURE__*/(0, _react2.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./nav_control_popover'))).then(({
        NavControlPopover
      }) => ({
        default: NavControlPopover
      })));
      _reactDom.default.render(core.rendering.addContext(/*#__PURE__*/_react2.default.createElement(_reactQuery.QueryClientProvider, {
        client: queryClient,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 53,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react2.default.createElement(_react2.Suspense, {
        fallback: /*#__PURE__*/_react2.default.createElement(_eui.EuiSkeletonRectangle, {
          css: (0, _react.css)`
                    margin-inline: ${_uiTheme.euiThemeVars.euiSizeS};
                  `,
          borderRadius: "m",
          contentAriaLabel: "Loading navigation",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 56,
            columnNumber: 17
          }
        }),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 54,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react2.default.createElement(LazyNavControlPopover, {
        spacesManager: spacesManager,
        serverBasePath: core.http.basePath.serverBasePath,
        anchorPosition: "downLeft",
        capabilities: core.application.capabilities,
        navigateToApp: core.application.navigateToApp,
        navigateToUrl: core.application.navigateToUrl,
        allowSolutionVisibility: config.allowSolutionVisibility,
        eventTracker: eventTracker,
        showTour$: tour.showTour$,
        onFinishTour: () => tour.finishTour(),
        manageSpacesDocsLink: core.docLinks.links.spaces.kibanaManageSpaces,
        manageSpacesLink: core.http.basePath.prepend('/app/management/kibana/spaces'),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 65,
          columnNumber: 15
        }
      })))), targetDomElement);
      return () => {
        _reactDom.default.unmountComponentAtNode(targetDomElement);
      };
    }
  });
}