"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SpacesGridPage = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _common = require("../../../common");
var _constants = require("../../../common/constants");
var _constants2 = require("../../constants");
var _space_avatar = require("../../space_avatar");
var _space_solution_badge = require("../../space_solution_badge");
var _components = require("../components");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/spaces/public/management/spaces_grid/spaces_grid_page.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// No need to wrap LazySpaceAvatar in an error boundary, because it is one of the first chunks loaded when opening Kibana.
const LazySpaceAvatar = /*#__PURE__*/(0, _react.lazy)(() => (0, _space_avatar.getSpaceAvatarComponent)().then(component => ({
  default: component
})));
class SpacesGridPage extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "onQueryChange", ({
      query
    }) => {
      var _query$text;
      const text = (query === null || query === void 0 ? void 0 : (_query$text = query.text) === null || _query$text === void 0 ? void 0 : _query$text.toLowerCase()) || '';
      this.setState({
        loading: true
      });
      const spacesFiltered = this.state.spaces.filter(space => {
        var _space$description;
        return space.name.toLowerCase().includes(text) || ((_space$description = space.description) === null || _space$description === void 0 ? void 0 : _space$description.toLowerCase().includes(text));
      });
      this.setState({
        spacesFiltered,
        loading: false
      });
    });
    (0, _defineProperty2.default)(this, "debouncedOnQueryChange", (0, _lodash.debounce)(this.onQueryChange, 200));
    (0, _defineProperty2.default)(this, "getConfirmDeleteModal", () => {
      if (!this.state.showConfirmDeleteModal || !this.state.selectedSpace) {
        return null;
      }
      const {
        spacesManager
      } = this.props;
      return /*#__PURE__*/_react.default.createElement(_components.ConfirmDeleteModal, {
        space: this.state.selectedSpace,
        spacesManager: spacesManager,
        onCancel: () => {
          this.setState({
            showConfirmDeleteModal: false
          });
        },
        onSuccess: () => {
          this.setState({
            showConfirmDeleteModal: false
          });
          this.loadGrid();
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 223,
          columnNumber: 7
        }
      });
    });
    (0, _defineProperty2.default)(this, "loadGrid", async () => {
      const {
        spacesManager,
        getFeatures,
        notifications
      } = this.props;
      this.setState({
        loading: true,
        spaces: [],
        spacesFiltered: [],
        features: []
      });
      const getSpaces = spacesManager.getSpaces();
      const getActiveSpace = spacesManager.getActiveSpace();
      try {
        const [spaces, activeSpace, features] = await Promise.all([getSpaces, getActiveSpace, getFeatures()]);
        this.setState({
          loading: false,
          spaces,
          spacesFiltered: spaces,
          activeSpace,
          features
        });
      } catch (error) {
        this.setState({
          loading: false
        });
        notifications.toasts.addError(error, {
          title: _i18n.i18n.translate('xpack.spaces.management.spacesGridPage.errorTitle', {
            defaultMessage: 'Error loading spaces'
          })
        });
      }
    });
    (0, _defineProperty2.default)(this, "getEditSpacePath", space => `edit/${encodeURIComponent(space.id)}`);
    (0, _defineProperty2.default)(this, "onDeleteSpaceClick", space => {
      this.setState({
        selectedSpace: space,
        showConfirmDeleteModal: true
      });
    });
    this.state = {
      spaces: [],
      spacesFiltered: [],
      activeSpace: null,
      features: [],
      loading: true,
      showConfirmDeleteModal: false,
      selectedSpace: null
    };
  }
  componentDidMount() {
    var _this$debouncedOnQuer;
    if (this.props.capabilities.spaces.manage) {
      this.loadGrid();
    }
    (_this$debouncedOnQuer = this.debouncedOnQueryChange) === null || _this$debouncedOnQuer === void 0 ? void 0 : _this$debouncedOnQuer.cancel();
  }
  render() {
    return /*#__PURE__*/_react.default.createElement("div", {
      className: "spcGridPage",
      "data-test-subj": "spaces-grid-page",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 98,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
      bottomBorder: true,
      pageTitle: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.spaces.management.spacesGridPage.spacesTitle",
        defaultMessage: "Spaces",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 102,
          columnNumber: 13
        }
      }),
      description: (0, _constants2.getSpacesFeatureDescription)(),
      rightSideItems: !this.state.loading && this.canCreateSpaces() ? [this.getPrimaryActionButton()] : undefined,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 99,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 114,
        columnNumber: 9
      }
    }), this.getPageContent(), this.getConfirmDeleteModal());
  }
  getPageContent() {
    if (!this.props.capabilities.spaces.manage) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiPageSection, {
        alignment: "center",
        color: "danger",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 142,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_components.UnauthorizedPrompt, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 143,
          columnNumber: 11
        }
      }));
    }
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !this.state.loading && !this.canCreateSpaces() ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: "You have reached the maximum number of allowed spaces.",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 152,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 153,
        columnNumber: 13
      }
    })) : undefined, /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
      itemId: 'id',
      "data-test-subj": "spacesListTable",
      items: this.state.spacesFiltered,
      tableCaption: _i18n.i18n.translate('xpack.spaces.management.spacesGridPage.tableCaption', {
        defaultMessage: 'Kibana spaces'
      }),
      rowHeader: "name",
      rowProps: item => ({
        'data-test-subj': `spacesListTableRow-${item.id}`
      }),
      columns: this.getColumnConfig(),
      pagination: true,
      sorting: true,
      search: {
        onChange: this.debouncedOnQueryChange,
        box: {
          incremental: true,
          placeholder: _i18n.i18n.translate('xpack.spaces.management.spacesGridPage.searchPlaceholder', {
            defaultMessage: 'Search'
          }),
          'data-test-subj': 'spacesListTableSearchBox'
        }
      },
      loading: this.state.loading,
      message: this.state.loading ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.spaces.management.spacesGridPage.loadingTitle",
        defaultMessage: "loading\u2026",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 184,
          columnNumber: 15
        }
      }) : undefined,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 156,
        columnNumber: 9
      }
    }));
  }
  canCreateSpaces() {
    return this.props.maxSpaces > this.state.spaces.length;
  }
  getPrimaryActionButton() {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, (0, _extends2.default)({
      fill: true,
      iconType: "plusInCircleFilled"
    }, (0, _public.reactRouterNavigate)(this.props.history, '/create'), {
      "data-test-subj": "createSpace",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 201,
        columnNumber: 7
      }
    }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.spaces.management.spacesGridPage.createSpaceButtonLabel",
      defaultMessage: "Create space",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 207,
        columnNumber: 9
      }
    }));
  }
  getColumnConfig() {
    const {
      activeSpace
    } = this.state;
    const config = [{
      field: 'initials',
      name: '',
      width: '50px',
      render: (_value, rowRecord) => {
        return /*#__PURE__*/_react.default.createElement(_react.Suspense, {
          fallback: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 289,
              columnNumber: 33
            }
          }),
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 289,
            columnNumber: 13
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, (0, _extends2.default)({}, (0, _public.reactRouterNavigate)(this.props.history, this.getEditSpacePath(rowRecord)), {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 290,
            columnNumber: 15
          }
        }), /*#__PURE__*/_react.default.createElement(LazySpaceAvatar, {
          space: rowRecord,
          size: "s",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 293,
            columnNumber: 17
          }
        })));
      }
    }, {
      field: 'name',
      name: _i18n.i18n.translate('xpack.spaces.management.spacesGridPage.spaceColumnName', {
        defaultMessage: 'Space'
      }),
      sortable: true,
      render: (value, rowRecord) => {
        const SpaceName = () => {
          var _this$state$activeSpa;
          const isCurrent = ((_this$state$activeSpa = this.state.activeSpace) === null || _this$state$activeSpa === void 0 ? void 0 : _this$state$activeSpa.id) === rowRecord.id;
          return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
            responsive: false,
            columns: 2,
            alignItems: "center",
            gutterSize: "s",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 309,
              columnNumber: 15
            }
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 310,
              columnNumber: 17
            }
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, (0, _extends2.default)({}, (0, _public.reactRouterNavigate)(this.props.history, this.getEditSpacePath(rowRecord)), {
            "data-test-subj": `${rowRecord.id}-hyperlink`,
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 311,
              columnNumber: 19
            }
          }), value)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 318,
              columnNumber: 17
            }
          }, isCurrent && /*#__PURE__*/_react.default.createElement("span", {
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 320,
              columnNumber: 21
            }
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
            color: "primary",
            "data-test-subj": `spacesListCurrentBadge-${rowRecord.id}`,
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 321,
              columnNumber: 23
            }
          }, _i18n.i18n.translate('xpack.spaces.management.spacesGridPage.currentSpaceMarkerText', {
            defaultMessage: 'current'
          })))));
        };
        return /*#__PURE__*/_react.default.createElement(SpaceName, {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 337,
            columnNumber: 18
          }
        });
      },
      'data-test-subj': 'spacesListTableRowNameCell',
      width: '20%'
    }, {
      field: 'description',
      name: _i18n.i18n.translate('xpack.spaces.management.spacesGridPage.descriptionColumnName', {
        defaultMessage: 'Description'
      }),
      sortable: true,
      truncateText: true
    }];
    if (this.props.allowSolutionVisibility) {
      config.push({
        field: 'solution',
        name: _i18n.i18n.translate('xpack.spaces.management.spacesGridPage.solutionColumnName', {
          defaultMessage: 'Solution view'
        }),
        sortable: true,
        render: (solution, record) => /*#__PURE__*/_react.default.createElement(_space_solution_badge.SpaceSolutionBadge, {
          solution: solution,
          "data-test-subj": `${record.id}-solution`,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 360,
            columnNumber: 11
          }
        }),
        width: '18%'
      });
    }
    config.push({
      name: _i18n.i18n.translate('xpack.spaces.management.spacesGridPage.actionsColumnName', {
        defaultMessage: 'Actions'
      }),
      actions: [{
        isPrimary: true,
        name: _i18n.i18n.translate('xpack.spaces.management.spacesGridPage.editSpaceActionName', {
          defaultMessage: `Edit`
        }),
        description: rowRecord => _i18n.i18n.translate('xpack.spaces.management.spacesGridPage.editSpaceActionDescription', {
          defaultMessage: `Edit {spaceName}.`,
          values: {
            spaceName: rowRecord.name
          }
        }),
        type: 'icon',
        icon: 'pencil',
        color: 'primary',
        href: rowRecord => (0, _public.reactRouterNavigate)(this.props.history, this.getEditSpacePath(rowRecord)).href,
        onClick: rowRecord => (0, _public.reactRouterNavigate)(this.props.history, this.getEditSpacePath(rowRecord)).onClick,
        'data-test-subj': rowRecord => `${rowRecord.id}-editSpace`
      }, {
        isPrimary: true,
        name: _i18n.i18n.translate('xpack.spaces.management.spacesGridPage.switchSpaceActionName', {
          defaultMessage: 'Switch'
        }),
        description: rowRecord => (activeSpace === null || activeSpace === void 0 ? void 0 : activeSpace.id) !== rowRecord.id ? _i18n.i18n.translate('xpack.spaces.management.spacesGridPage.switchSpaceActionDescription', {
          defaultMessage: 'Switch to {spaceName}',
          values: {
            spaceName: rowRecord.name
          }
        }) : _i18n.i18n.translate('xpack.spaces.management.spacesGridPage.switchSpaceActionDisabledDescription', {
          defaultMessage: '{spaceName} is the current space',
          values: {
            spaceName: rowRecord.name
          }
        }),
        type: 'icon',
        icon: 'merge',
        color: 'primary',
        href: rowRecord => (0, _common.addSpaceIdToPath)(this.props.serverBasePath, rowRecord.id, `${_constants.ENTER_SPACE_PATH}?next=/app/management/kibana/spaces/`),
        enabled: rowRecord => (activeSpace === null || activeSpace === void 0 ? void 0 : activeSpace.id) !== rowRecord.id,
        'data-test-subj': rowRecord => `${rowRecord.id}-switchSpace`
      }, {
        name: _i18n.i18n.translate('xpack.spaces.management.spacesGridPage.deleteActionName', {
          defaultMessage: `Delete`
        }),
        description: rowRecord => (0, _common.isReservedSpace)(rowRecord) ? _i18n.i18n.translate('xpack.spaces.management.spacesGridPage.deleteActionDisabledDescription', {
          defaultMessage: `You can't delete the {spaceName} space`,
          values: {
            spaceName: rowRecord.name
          }
        }) : _i18n.i18n.translate('xpack.spaces.management.spacesGridPage.deleteActionDescription', {
          defaultMessage: `Delete {spaceName}`,
          values: {
            spaceName: rowRecord.name
          }
        }),
        type: 'icon',
        icon: 'trash',
        color: 'danger',
        onClick: rowRecord => this.onDeleteSpaceClick(rowRecord),
        enabled: rowRecord => !(0, _common.isReservedSpace)(rowRecord),
        'data-test-subj': rowRecord => `${rowRecord.id}-deleteSpace`
      }],
      width: '18%'
    });
    return config;
  }
}
exports.SpacesGridPage = SpacesGridPage;