"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditSpaceSettingsTab = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _unsavedChangesPrompt = require("@kbn/unsaved-changes-prompt");
var _footer = require("./footer");
var _provider = require("./provider");
var _constants = require("../../../common/constants");
var _space_avatar = require("../../space_avatar");
var _components = require("../components");
var _confirm_alter_active_space_modal = require("../components/confirm_alter_active_space_modal");
var _customize_avatar = require("../components/customize_avatar");
var _customize_space = require("../components/customize_space");
var _enabled_features = require("../components/enabled_features");
var _solution_view = require("../components/solution_view");
var _lib = require("../lib");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/spaces/public/management/edit_space/edit_space_general_tab.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const EditSpaceSettingsTab = ({
  space,
  features,
  history,
  ...props
}) => {
  const imageAvatarSelected = Boolean(space.imageUrl);
  const [formValues, setFormValues] = (0, _react.useState)({
    ...space,
    avatarType: imageAvatarSelected ? 'image' : 'initials',
    imageUrl: imageAvatarSelected ? space.imageUrl : ''
  });

  // space initials are blank by default, they must be calculated
  const getSpaceFromFormValues = newFormValues => {
    return {
      ...newFormValues,
      initials: (0, _space_avatar.getSpaceInitials)(newFormValues)
    };
  };
  const [isDirty, setIsDirty] = (0, _react.useState)(false); // track if unsaved changes have been made
  const [isLoading, setIsLoading] = (0, _react.useState)(false); // track if user has just clicked the Update button
  const [showUserImpactWarning, setShowUserImpactWarning] = (0, _react.useState)(false);
  const [showAlteringActiveSpaceDialog, setShowAlteringActiveSpaceDialog] = (0, _react.useState)(false);
  const [showConfirmDeleteModal, setShowConfirmDeleteModal] = (0, _react.useState)(false);
  const {
    http,
    overlays,
    logger,
    notifications,
    navigateToUrl,
    spacesManager
  } = (0, _provider.useEditSpaceServices)();
  const [solution, setSolution] = (0, _react.useState)(space.solution);
  (0, _unsavedChangesPrompt.useUnsavedChangesPrompt)({
    hasUnsavedChanges: isDirty,
    http,
    openConfirm: overlays.openConfirm,
    navigateToUrl,
    history,
    titleText: _i18n.i18n.translate('xpack.spaces.management.spaceDetails.unsavedChangesPromptTitle', {
      defaultMessage: 'Leave without saving?'
    }),
    messageText: _i18n.i18n.translate('xpack.spaces.management.spaceDetails.unsavedChangesPromptMessage', {
      defaultMessage: "Unsaved changes won't be applied to the space and will be lost."
    }),
    cancelButtonText: _i18n.i18n.translate('xpack.spaces.management.spaceDetails.keepEditingButton', {
      defaultMessage: 'Save before leaving'
    }),
    confirmButtonText: _i18n.i18n.translate('xpack.spaces.management.spaceDetails.leavePageButton', {
      defaultMessage: 'Leave'
    })
  });
  const onChangeSpaceSettings = (0, _react.useCallback)(newFormValues => {
    setFormValues({
      ...formValues,
      ...newFormValues
    });
    setIsDirty(true);
  }, [formValues]);
  const onChangeFeatures = (0, _react.useCallback)(updatedSpace => {
    setFormValues({
      ...formValues,
      ...updatedSpace
    });
    setIsDirty(true);
    setShowUserImpactWarning(true);
  }, [formValues]);
  const onSolutionViewChange = (0, _react.useCallback)(updatedSpace => {
    setSolution(updatedSpace.solution);
    onChangeFeatures(updatedSpace);
  }, [onChangeFeatures]);
  const backToSpacesList = (0, _react.useCallback)(() => {
    history.push('/');
  }, [history]);
  const onClickCancel = (0, _react.useCallback)(() => {
    setShowAlteringActiveSpaceDialog(false);
    setShowUserImpactWarning(false);
    backToSpacesList();
  }, [backToSpacesList]);
  const onClickDeleteSpace = (0, _react.useCallback)(() => {
    setShowConfirmDeleteModal(true);
  }, []);
  const performSave = (0, _react.useCallback)(async ({
    requiresReload = false
  }) => {
    const {
      avatarType,
      customIdentifier,
      customAvatarColor,
      customAvatarInitials,
      ...partialSpace
    } = formValues;
    const spaceClone = structuredClone(partialSpace);
    const {
      id,
      name
    } = spaceClone;
    if (!id) {
      throw new Error(`Can not update space without id field!`);
    }
    if (!name) {
      throw new Error(`Can not update space without name field!`);
    }
    setIsLoading(true);
    let disabledFeatures;
    if (!spaceClone.solution || spaceClone.solution === _constants.SOLUTION_VIEW_CLASSIC) {
      disabledFeatures = spaceClone.disabledFeatures;
    }
    try {
      var _disabledFeatures;
      await spacesManager.updateSpace({
        ...spaceClone,
        id,
        name,
        disabledFeatures: (_disabledFeatures = disabledFeatures) !== null && _disabledFeatures !== void 0 ? _disabledFeatures : [],
        imageUrl: avatarType === 'image' ? spaceClone.imageUrl : ''
      });
      notifications.toasts.addSuccess(_i18n.i18n.translate('xpack.spaces.management.spaceDetails.spaceSuccessfullySavedNotificationMessage', {
        defaultMessage: 'Space "{name}" was saved.',
        values: {
          name
        }
      }));
      setIsDirty(false);
      backToSpacesList();
      if (requiresReload) {
        props.reloadWindow();
      }
    } catch (error) {
      var _error$body$message, _error$body;
      logger.error('Could not save changes to space!', error);
      const message = (_error$body$message = error === null || error === void 0 ? void 0 : (_error$body = error.body) === null || _error$body === void 0 ? void 0 : _error$body.message) !== null && _error$body$message !== void 0 ? _error$body$message : error.toString();
      notifications.toasts.addError(error, {
        title: _i18n.i18n.translate('xpack.spaces.management.spaceDetails.errorSavingSpaceTitle', {
          defaultMessage: 'Error saving space: {message}',
          values: {
            message
          }
        })
      });
    } finally {
      setIsLoading(false);
    }
  }, [backToSpacesList, notifications.toasts, formValues, spacesManager, logger, props]);
  const validator = (0, _react.useMemo)(() => new _lib.SpaceValidator(), []);
  const onClickSubmit = (0, _react.useCallback)(() => {
    validator.enableValidation();
    const validationResult = validator.validateForSave(formValues, true, props.allowSolutionVisibility);
    if (validationResult.isInvalid) {
      // invalid form input fields will show the error message
      return;
    }
    if (showUserImpactWarning) {
      setShowAlteringActiveSpaceDialog(true);
    } else {
      performSave({
        requiresReload: false
      });
    }
  }, [validator, formValues, props.allowSolutionVisibility, performSave, showUserImpactWarning]);
  const doShowAlteringActiveSpaceDialog = () => {
    return showAlteringActiveSpaceDialog && /*#__PURE__*/_react.default.createElement(_confirm_alter_active_space_modal.ConfirmAlterActiveSpaceModal, {
      onConfirm: () => performSave({
        requiresReload: true
      }),
      onCancel: () => {
        setShowAlteringActiveSpaceDialog(false);
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 216,
        columnNumber: 9
      }
    });
  };
  const doShowConfirmDeleteSpaceDialog = () => {
    return showConfirmDeleteModal && /*#__PURE__*/_react.default.createElement(_components.ConfirmDeleteModal, {
      space: space,
      spacesManager: spacesManager,
      onCancel: () => {
        setShowConfirmDeleteModal(false);
      },
      onSuccess: () => {
        setShowConfirmDeleteModal(false);
        backToSpacesList();
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 229,
        columnNumber: 9
      }
    });
  };

  // Show if user has changed disabled features
  // Show if user has changed solution view
  const doShowUserImpactWarning = () => {
    return showUserImpactWarning && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 250,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      color: "warning",
      iconType: "info",
      title: _i18n.i18n.translate('xpack.spaces.management.spaceDetails.spaceChangesWarning.impactAllUsersInSpace', {
        defaultMessage: 'The changes will apply to all users of the space.'
      }),
      "data-test-subj": "space-edit-page-user-impact-warning",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 251,
        columnNumber: 11
      }
    }));
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, doShowAlteringActiveSpaceDialog(), doShowConfirmDeleteSpaceDialog(), /*#__PURE__*/_react.default.createElement(_customize_space.CustomizeSpace, {
    space: getSpaceFromFormValues(formValues),
    onChange: onChangeSpaceSettings,
    editingExistingSpace: true,
    validator: validator,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 272,
      columnNumber: 7
    }
  }), props.allowSolutionVisibility && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 281,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_solution_view.SolutionView, {
    space: getSpaceFromFormValues(formValues),
    onChange: onSolutionViewChange,
    validator: validator,
    isEditing: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 282,
      columnNumber: 11
    }
  })), props.allowFeatureVisibility && (!solution || solution === _constants.SOLUTION_VIEW_CLASSIC) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 293,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_enabled_features.EnabledFeatures, {
    features: features,
    space: getSpaceFromFormValues(formValues),
    onChange: onChangeFeatures,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 294,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 302,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_customize_avatar.CustomizeAvatar, {
    space: getSpaceFromFormValues(formValues),
    onChange: onChangeSpaceSettings,
    validator: validator,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 304,
      columnNumber: 7
    }
  }), doShowUserImpactWarning(), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 312,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_footer.EditSpaceTabFooter, {
    isDirty: isDirty,
    isLoading: isLoading,
    onClickCancel: onClickCancel,
    onClickSubmit: onClickSubmit,
    onClickDeleteSpace: onClickDeleteSpace,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 313,
      columnNumber: 7
    }
  }));
};
exports.EditSpaceSettingsTab = EditSpaceSettingsTab;