"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SolutionView = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../../../../common/constants");
var _section_panel = require("../section_panel");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/spaces/public/management/components/solution_view/solution_view.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const getOptions = ({
  size
}) => {
  const iconCss = {
    marginRight: size.m
  };
  return [{
    value: 'es',
    inputDisplay: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "logoElasticsearch",
      css: iconCss,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 42,
        columnNumber: 11
      }
    }), _i18n.i18n.translate('xpack.spaces.management.manageSpacePage.solutionViewSelect.searchOptionLabel', {
      defaultMessage: 'Elasticsearch'
    })),
    'data-test-subj': 'solutionViewEsOption'
  }, {
    value: 'oblt',
    inputDisplay: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "logoObservability",
      css: iconCss,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 55,
        columnNumber: 11
      }
    }), _i18n.i18n.translate('xpack.spaces.management.manageSpacePage.solutionViewSelect.obltOptionLabel', {
      defaultMessage: 'Observability'
    })),
    'data-test-subj': 'solutionViewObltOption'
  }, {
    value: 'security',
    inputDisplay: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "logoSecurity",
      css: iconCss,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 68,
        columnNumber: 11
      }
    }), _i18n.i18n.translate('xpack.spaces.management.manageSpacePage.solutionViewSelect.securityOptionLabel', {
      defaultMessage: 'Security'
    })),
    'data-test-subj': 'solutionViewSecurityOption'
  }, {
    value: 'classic',
    inputDisplay: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "logoElasticStack",
      css: iconCss,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 81,
        columnNumber: 11
      }
    }), _i18n.i18n.translate('xpack.spaces.management.manageSpacePage.solutionViewSelect.classicOptionLabel', {
      defaultMessage: 'Classic'
    })),
    'data-test-subj': 'solutionViewClassicOption'
  }];
};
const SolutionView = ({
  space,
  onChange,
  validator,
  isEditing,
  sectionTitle
}) => {
  var _space$solution;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const showClassicDefaultViewCallout = isEditing && space.solution == null;
  return /*#__PURE__*/_react.default.createElement(_section_panel.SectionPanel, {
    title: sectionTitle,
    dataTestSubj: "navigationPanel",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "baseline",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.spaces.management.manageSpacePage.setSolutionViewMessage",
    defaultMessage: "Select solution view",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 19
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
    label: _i18n.i18n.translate('xpack.spaces.management.manageSpacePage.setSolutionViewNewBadge', {
      defaultMessage: 'New'
    }),
    color: "accent",
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 17
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.spaces.management.manageSpacePage.setSolutionViewDescription",
    defaultMessage: "Focus the navigation and menus of this space on a specific solution. Features that are not relevant to the selected solution are no longer visible to users of this space.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 15
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({
    label: _i18n.i18n.translate('xpack.spaces.management.navigation.solutionViewLabel', {
      defaultMessage: 'Solution view'
    }),
    fullWidth: true,
    helpText: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 154,
        columnNumber: 15
      }
    }, showClassicDefaultViewCallout ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.spaces.management.manageSpacePage.solutionViewSelect.classicDefaultViewCallout",
      defaultMessage: "Affects all users of the space",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 156,
        columnNumber: 19
      }
    }) : null)
  }, validator.validateSolutionView(space, isEditing), {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    options: getOptions(euiTheme),
    valueOfSelected: (_space$solution = space.solution) !== null && _space$solution !== void 0 ? _space$solution : showClassicDefaultViewCallout ? _constants.SOLUTION_VIEW_CLASSIC : undefined,
    "data-test-subj": "solutionViewSelect",
    onChange: solution => {
      onChange({
        ...space,
        solution
      });
    },
    fullWidth: true,
    placeholder: _i18n.i18n.translate('xpack.spaces.management.navigation.solutionViewDefaultValue', {
      defaultMessage: 'Select solution view'
    }),
    isInvalid: validator.validateSolutionView(space, isEditing).isInvalid,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 13
    }
  })))));
};
exports.SolutionView = SolutionView;