"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CustomizeSpaceAvatar = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _common = require("../../../../common");
var _dataurl = require("../../../../common/lib/dataurl");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/spaces/public/management/components/customize_avatar/customize_space_avatar.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class CustomizeSpaceAvatar extends _react.Component {
  constructor(...args) {
    super(...args);
    //
    // images below 64x64 pixels are left untouched
    // images above that threshold are resized
    //
    (0, _defineProperty2.default)(this, "handleImageUpload", imgUrl => {
      const thisInstance = this;
      const image = new Image();
      image.addEventListener('load', function () {
        const MAX_IMAGE_SIZE = 64;
        const imgDimx = image.width;
        const imgDimy = image.height;
        if (imgDimx <= MAX_IMAGE_SIZE && imgDimy <= MAX_IMAGE_SIZE) {
          thisInstance.storeImageChanges(imgUrl);
        } else {
          const imageCanvas = document.createElement('canvas');
          const canvasContext = imageCanvas.getContext('2d');
          if (imgDimx >= imgDimy) {
            imageCanvas.width = MAX_IMAGE_SIZE;
            imageCanvas.height = Math.floor(imgDimy * MAX_IMAGE_SIZE / imgDimx);
            if (canvasContext) {
              canvasContext.drawImage(image, 0, 0, imageCanvas.width, imageCanvas.height);
              const resizedImageUrl = imageCanvas.toDataURL();
              thisInstance.storeImageChanges(resizedImageUrl);
            }
          } else {
            imageCanvas.height = MAX_IMAGE_SIZE;
            imageCanvas.width = Math.floor(imgDimx * MAX_IMAGE_SIZE / imgDimy);
            if (canvasContext) {
              canvasContext.drawImage(image, 0, 0, imageCanvas.width, imageCanvas.height);
              const resizedImageUrl = imageCanvas.toDataURL();
              thisInstance.storeImageChanges(resizedImageUrl);
            }
          }
        }
      }, false);
      image.src = imgUrl;
    });
    (0, _defineProperty2.default)(this, "onFileUpload", files => {
      if (files == null || files.length === 0) {
        this.storeImageChanges(undefined);
        return;
      }
      const file = files[0];
      if (_dataurl.imageTypes.indexOf(file.type) > -1) {
        (0, _dataurl.encode)(file).then(dataurl => this.handleImageUpload(dataurl));
      }
    });
    (0, _defineProperty2.default)(this, "onInitialsChange", e => {
      const initials = (e.target.value || '').substring(0, _common.MAX_SPACE_INITIALS);
      this.props.onChange({
        ...this.props.space,
        customAvatarInitials: true,
        initials
      });
    });
    (0, _defineProperty2.default)(this, "onColorChange", color => {
      this.props.onChange({
        ...this.props.space,
        customAvatarColor: true,
        color
      });
    });
  }
  storeImageChanges(imageUrl) {
    this.props.onChange({
      ...this.props.space,
      imageUrl
    });
  }
  render() {
    var _space$avatarType, _space$initials, _space$color;
    const {
      space
    } = this.props;
    return /*#__PURE__*/_react.default.createElement("form", {
      onSubmit: () => false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 97,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: _i18n.i18n.translate('xpack.spaces.management.customizeSpaceAvatar.avatarTypeFormRowLabel', {
        defaultMessage: 'Avatar type'
      }),
      fullWidth: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 98,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
      legend: "",
      options: [{
        id: `initials`,
        label: _i18n.i18n.translate('xpack.spaces.management.customizeSpaceAvatar.initialsLabel', {
          defaultMessage: 'Initials'
        })
      }, {
        id: `image`,
        label: _i18n.i18n.translate('xpack.spaces.management.customizeSpaceAvatar.imageLabel', {
          defaultMessage: 'Image'
        })
      }],
      idSelected: (_space$avatarType = space.avatarType) !== null && _space$avatarType !== void 0 ? _space$avatarType : 'initials',
      onChange: avatarType => this.props.onChange({
        ...space,
        avatarType: avatarType
      }),
      buttonSize: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 107,
        columnNumber: 11
      }
    })), space.avatarType !== 'image' ? /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({
      label: _i18n.i18n.translate('xpack.spaces.management.customizeSpaceAvatar.initialsLabel', {
        defaultMessage: 'Initials'
      }),
      helpText: _i18n.i18n.translate('xpack.spaces.management.customizeSpaceAvatar.initialsHelpText', {
        defaultMessage: 'Enter up to two characters.'
      })
    }, this.props.validator.validateAvatarInitials(space), {
      fullWidth: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 137,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      "data-test-subj": "spaceLetterInitial",
      name: "spaceInitials",
      value: (_space$initials = space.initials) !== null && _space$initials !== void 0 ? _space$initials : '',
      onChange: this.onInitialsChange,
      isInvalid: this.props.validator.validateAvatarInitials(space).isInvalid,
      fullWidth: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 150,
        columnNumber: 13
      }
    })) : /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({
      label: _i18n.i18n.translate('xpack.spaces.management.customizeSpaceAvatar.imageUrlLabel', {
        defaultMessage: 'Image'
      })
    }, this.props.validator.validateAvatarImage(space), {
      fullWidth: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 160,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFilePicker, {
      display: "default",
      "data-test-subj": "uploadCustomImageFile",
      initialPromptText: _i18n.i18n.translate('xpack.spaces.management.customizeSpaceAvatar.imageUrlPromptText', {
        defaultMessage: 'Select image file'
      }),
      onChange: this.onFileUpload,
      accept: _dataurl.imageTypes.join(','),
      isInvalid: this.props.validator.validateAvatarImage(space).isInvalid,
      fullWidth: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 167,
        columnNumber: 13
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({
      label: _i18n.i18n.translate('xpack.spaces.management.customizeSpaceAvatar.colorLabel', {
        defaultMessage: 'Background color'
      })
    }, this.props.validator.validateAvatarColor(space), {
      fullWidth: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 183,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiColorPicker, {
      color: (_space$color = space.color) !== null && _space$color !== void 0 ? _space$color : '',
      onChange: this.onColorChange,
      isInvalid: this.props.validator.validateAvatarColor(space).isInvalid,
      fullWidth: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 190,
        columnNumber: 11
      }
    })));
  }
}
exports.CustomizeSpaceAvatar = CustomizeSpaceAvatar;