"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CopyStatusSummaryIndicator = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _react2 = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _resolve_all_conflicts = require("./resolve_all_conflicts");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/spaces/public/copy_saved_objects_to_space/components/copy_status_summary_indicator.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CopyStatusIcon = props => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    space,
    summarizedCopyResult,
    conflictResolutionInProgress,
    retries,
    onRetriesChange,
    onDestinationMapChange
  } = props;
  const getDataTestSubj = status => `cts-summary-indicator-${status}-${space.id}`;
  if (summarizedCopyResult.processing || conflictResolutionInProgress) {
    return /*#__PURE__*/_react2.default.createElement(_eui.EuiLoadingSpinner, {
      "data-test-subj": getDataTestSubj('loading'),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 41,
        columnNumber: 12
      }
    });
  }
  const {
    successful,
    hasUnresolvableErrors,
    hasMissingReferences,
    hasConflicts
  } = summarizedCopyResult;
  if (successful) {
    return /*#__PURE__*/_react2.default.createElement(_eui.EuiIconTip, {
      type: 'checkInCircleFilled',
      color: 'success',
      iconProps: {
        'data-test-subj': getDataTestSubj('success')
      },
      content: /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.spaces.management.copyToSpace.copyStatusSummary.successMessage",
        defaultMessage: "Copy to the {space} space was successful.",
        values: {
          space: space.name
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 56,
          columnNumber: 11
        }
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 49,
        columnNumber: 7
      }
    });
  }
  if (hasUnresolvableErrors) {
    return /*#__PURE__*/_react2.default.createElement(_eui.EuiIconTip, {
      type: 'alert',
      color: 'danger',
      iconProps: {
        'data-test-subj': getDataTestSubj('failed')
      },
      content: /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.spaces.management.copyToSpace.copyStatusSummary.failedMessage",
        defaultMessage: "Copy to the {space} space failed. Expand this section for details.",
        values: {
          space: space.name
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 75,
          columnNumber: 11
        }
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 68,
        columnNumber: 7
      }
    });
  }
  const missingReferences = hasMissingReferences ? /*#__PURE__*/_react2.default.createElement("span", {
    css: (0, _react.css)`
        margin-left: ${euiTheme.size.xs};
      `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiIconTip, {
    type: 'link',
    color: 'warning',
    iconProps: {
      'data-test-subj': getDataTestSubj('missingReferences')
    },
    content: /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.spaces.management.copyToSpace.copyStatusSummary.missingReferencesMessage",
      defaultMessage: "Missing references detected in the {space} space. Expand this section for details.",
      values: {
        space: space.name
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 98,
        columnNumber: 11
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 7
    }
  })) : null;
  if (hasConflicts) {
    return /*#__PURE__*/_react2.default.createElement(_react2.Fragment, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 110,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react2.default.createElement(_resolve_all_conflicts.ResolveAllConflicts, {
      summarizedCopyResult: summarizedCopyResult,
      retries: retries,
      onRetriesChange: onRetriesChange,
      onDestinationMapChange: onDestinationMapChange,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 111,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react2.default.createElement(_eui.EuiIconTip, {
      type: 'alert',
      color: 'warning',
      iconProps: {
        'data-test-subj': getDataTestSubj('conflicts')
      },
      content: /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.spaces.management.copyToSpace.copyStatusSummary.conflictsMessage",
        defaultMessage: "Conflicts detected in the {space} space. Expand this section to resolve.",
        values: {
          space: space.name
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 124,
          columnNumber: 13
        }
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 117,
        columnNumber: 9
      }
    }), missingReferences);
  }
  return missingReferences;
};
const CopyStatusSummaryIndicator = props => {
  const {
    summarizedCopyResult
  } = props;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react2.default.createElement(_react2.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(CopyStatusIcon, (0, _extends2.default)({}, props, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 7
    }
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiBadge, {
    css: (0, _react.css)`
          margin-left: ${euiTheme.size.xs};
        `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 7
    }
  }, summarizedCopyResult.objects.length));
};
exports.CopyStatusSummaryIndicator = CopyStatusSummaryIndicator;