"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UNKNOWN_SPACE = exports.SPACE_SEARCH_COUNT_THRESHOLD = exports.SOLUTION_VIEW_CLASSIC = exports.SHOW_SPACE_SOLUTION_TOUR_SETTING = exports.MAX_SPACE_INITIALS = exports.FEATURE_PRIVILEGES_READ = exports.FEATURE_PRIVILEGES_CUSTOM = exports.FEATURE_PRIVILEGES_ALL = exports.ENTER_SPACE_PATH = exports.DEFAULT_SPACE_ID = exports.API_VERSIONS = exports.ALL_SPACES_ID = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_SPACE_ID = exports.DEFAULT_SPACE_ID = `default`;

/**
 * The identifier in a saved object's `namespaces` array when it is shared globally to all spaces.
 */
const ALL_SPACES_ID = exports.ALL_SPACES_ID = '*';

/**
 * The identifier in a saved object's `namespaces` array when it is shared to an unknown space (e.g., one that the end user is not authorized to see).
 */
const UNKNOWN_SPACE = exports.UNKNOWN_SPACE = '?';

/**
 * The minimum number of spaces required to show a search control.
 */
const SPACE_SEARCH_COUNT_THRESHOLD = exports.SPACE_SEARCH_COUNT_THRESHOLD = 8;

/**
 * The maximum number of characters allowed in the Space Avatar's initials
 */
const MAX_SPACE_INITIALS = exports.MAX_SPACE_INITIALS = 2;

/**
 * The path to enter a space.
 */
const ENTER_SPACE_PATH = exports.ENTER_SPACE_PATH = '/spaces/enter';

/**
 * The 'classic' solution view is the default, non-project type of solution view
 */
const SOLUTION_VIEW_CLASSIC = exports.SOLUTION_VIEW_CLASSIC = 'classic';

/**
 * The feature privileges constants are used to identify the granularity of the configured feature visibility
 */
const FEATURE_PRIVILEGES_ALL = exports.FEATURE_PRIVILEGES_ALL = 'all';
const FEATURE_PRIVILEGES_READ = exports.FEATURE_PRIVILEGES_READ = 'read';
const FEATURE_PRIVILEGES_CUSTOM = exports.FEATURE_PRIVILEGES_CUSTOM = 'custom';

/**
 * The API version numbers used with the versioned router.
 */
const API_VERSIONS = exports.API_VERSIONS = {
  public: {
    v1: '2023-10-31'
  }
};

/**
 * The setting to control whether the Space Solution Tour is shown.
 */
const SHOW_SPACE_SOLUTION_TOUR_SETTING = exports.SHOW_SPACE_SOLUTION_TOUR_SETTING = 'showSpaceSolutionTour';