"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AzureSettings = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _common = require("./common");
var _disable_tooltip = require("../../disable_tooltip");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/snapshot_restore/public/application/components/repository_form/type_settings/azure_settings.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AzureSettings = ({
  repository,
  isManagedRepository,
  updateRepositorySettings,
  settingErrors
}) => {
  const {
    settings: {
      client,
      container,
      basePath,
      compress,
      chunkSize,
      readonly,
      locationMode,
      maxRestoreBytesPerSec,
      maxSnapshotBytesPerSec
    }
  } = repository;
  const clientId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'azureClientInput'
  });
  const containerId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'azureContainerInput'
  });
  const basePathId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'azureBasePathInput'
  });
  const hasErrors = Boolean(Object.keys(settingErrors).length);
  const locationModeOptions = ['primary_only', 'secondary_only'].map(option => ({
    value: option,
    text: option
  }));
  const updateSettings = (name, value) => {
    updateRepositorySettings({
      [name]: value
    });
  };
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 80,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("h3", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 81,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.typeAzure.clientTitle",
      defaultMessage: "Client",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 82,
        columnNumber: 15
      }
    }))),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.typeAzure.clientDescription",
      defaultMessage: "The name of the Azure client.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 90,
        columnNumber: 11
      }
    }),
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement("span", {
      id: clientId,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 99,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.typeAzure.clientLabel",
      defaultMessage: "Client",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 100,
        columnNumber: 15
      }
    })),
    fullWidth: true,
    isInvalid: Boolean(hasErrors && settingErrors.client),
    error: settingErrors.client,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_disable_tooltip.DisableToolTip, {
    isManaged: isManagedRepository,
    tooltipMessage: _disable_tooltip.MANAGED_REPOSITORY_TOOLTIP_MESSAGE,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    defaultValue: client || '',
    fullWidth: true,
    onChange: e => {
      updateRepositorySettings({
        client: e.target.value
      });
    },
    "data-test-subj": "clientInput",
    disabled: isManagedRepository,
    "aria-labelledby": clientId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 13
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 133,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("h3", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 134,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.typeAzure.containerTitle",
      defaultMessage: "Container",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 135,
        columnNumber: 15
      }
    }))),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.typeAzure.containerDescription",
      defaultMessage: "The name of the Azure container to use for snapshots.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 143,
        columnNumber: 11
      }
    }),
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement("span", {
      id: containerId,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 152,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.typeAzure.containerLabel",
      defaultMessage: "Container",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 153,
        columnNumber: 15
      }
    })),
    fullWidth: true,
    isInvalid: Boolean(hasErrors && settingErrors.container),
    error: settingErrors.container,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_disable_tooltip.DisableToolTip, {
    isManaged: isManagedRepository,
    tooltipMessage: _disable_tooltip.MANAGED_REPOSITORY_TOOLTIP_MESSAGE,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    defaultValue: container || '',
    fullWidth: true,
    onChange: e => {
      updateRepositorySettings({
        container: e.target.value
      });
    },
    "data-test-subj": "containerInput",
    disabled: isManagedRepository,
    "aria-labelledby": containerId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 13
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 186,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("h3", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 187,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.typeAzure.basePathTitle",
      defaultMessage: "Base path",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 188,
        columnNumber: 15
      }
    }))),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.typeAzure.basePathDescription",
      defaultMessage: "The container path to the repository data.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 196,
        columnNumber: 11
      }
    }),
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 184,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement("span", {
      id: basePathId,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 205,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.typeAzure.basePathLabel",
      defaultMessage: "Base path",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 206,
        columnNumber: 15
      }
    })),
    fullWidth: true,
    isInvalid: Boolean(hasErrors && settingErrors.basePath),
    error: settingErrors.basePath,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 203,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_disable_tooltip.DisableToolTip, {
    isManaged: isManagedRepository,
    tooltipMessage: _disable_tooltip.MANAGED_REPOSITORY_TOOLTIP_MESSAGE,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 216,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    defaultValue: basePath || '',
    fullWidth: true,
    onChange: e => {
      updateRepositorySettings({
        basePath: e.target.value
      });
    },
    "data-test-subj": "basePathInput",
    disabled: isManagedRepository,
    "aria-labelledby": basePathId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 220,
      columnNumber: 13
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 239,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("h3", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 240,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.typeAzure.compressTitle",
      defaultMessage: "Snapshot compression",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 241,
        columnNumber: 15
      }
    }))),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.typeAzure.compressDescription",
      defaultMessage: "Compresses the index mapping and setting files for snapshots. Data files are not compressed.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 249,
        columnNumber: 11
      }
    }),
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 237,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    isInvalid: Boolean(hasErrors && settingErrors.compress),
    error: settingErrors.compress,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 256,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.typeAzure.compressLabel",
      defaultMessage: "Compress snapshots",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 263,
        columnNumber: 15
      }
    }),
    checked: !(compress === false),
    onChange: e => {
      updateRepositorySettings({
        compress: e.target.checked
      });
    },
    "data-test-subj": "compressToggle",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 261,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_common.ChunkSizeField, {
    isInvalid: Boolean(hasErrors && settingErrors.chunkSize),
    error: settingErrors.chunkSize,
    defaultValue: chunkSize || '',
    updateSettings: updateSettings,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 280,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_common.MaxSnapshotsField, {
    isInvalid: Boolean(hasErrors && settingErrors.maxSnapshotBytesPerSec),
    error: settingErrors.maxSnapshotBytesPerSec,
    defaultValue: maxSnapshotBytesPerSec || '',
    updateSettings: updateSettings,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 288,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_common.MaxRestoreField, {
    isInvalid: Boolean(hasErrors && settingErrors.maxRestoreBytesPerSec),
    error: settingErrors.maxRestoreBytesPerSec,
    defaultValue: maxRestoreBytesPerSec || '',
    updateSettings: updateSettings,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 296,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 306,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("h3", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 307,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.typeAzure.locationModeTitle",
      defaultMessage: "Location mode",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 308,
        columnNumber: 15
      }
    }))),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.typeAzure.locationModeDescription",
      defaultMessage: "The primary or secondary location. If secondary, read-only is true.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 316,
        columnNumber: 11
      }
    }),
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 304,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.typeAzure.locationModeLabel",
      defaultMessage: "Location mode",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 325,
        columnNumber: 13
      }
    }),
    fullWidth: true,
    isInvalid: Boolean(hasErrors && settingErrors.locationMode),
    error: settingErrors.locationMode,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 323,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    isInvalid: Boolean(hasErrors && settingErrors.locationMode),
    options: locationModeOptions,
    value: locationMode || locationModeOptions[0].value,
    onChange: e => {
      updateRepositorySettings({
        locationMode: e.target.value,
        readonly: e.target.value === locationModeOptions[1].value ? true : readonly
      });
    },
    fullWidth: true,
    "data-test-subj": "locationModeSelect",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 334,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 353,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("h3", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 354,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.typeAzure.readonlyTitle",
      defaultMessage: "Read-only",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 355,
        columnNumber: 15
      }
    }))),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.typeAzure.readonlyDescription",
      defaultMessage: "Only one cluster should have write access to this repository. All other clusters should be read-only.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 363,
        columnNumber: 11
      }
    }),
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 351,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    isInvalid: Boolean(hasErrors && settingErrors.readonly),
    error: settingErrors.readonly,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 370,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    disabled: locationMode === locationModeOptions[1].value,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.typeAzure.readonlyLabel",
      defaultMessage: "Read-only repository",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 378,
        columnNumber: 15
      }
    }),
    checked: !!readonly,
    onChange: e => {
      updateRepositorySettings({
        readonly: locationMode === locationModeOptions[1].value ? true : e.target.checked
      });
    },
    "data-test-subj": "readOnlyToggle",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 375,
      columnNumber: 11
    }
  }))));
};
exports.AzureSettings = AzureSettings;