"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FindSLODefinitions = void 0;
var _sloSchema = require("@kbn/slo-schema");
var _errors = require("../errors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MAX_PER_PAGE = 1000;
const DEFAULT_PER_PAGE = 100;
const DEFAULT_PAGE = 1;
class FindSLODefinitions {
  constructor(repository) {
    this.repository = repository;
  }
  async execute(params) {
    var _params$tags$split, _params$tags, _params$search;
    const requestTags = (_params$tags$split = (_params$tags = params.tags) === null || _params$tags === void 0 ? void 0 : _params$tags.split(',')) !== null && _params$tags$split !== void 0 ? _params$tags$split : [];
    const result = await this.repository.search((_params$search = params.search) !== null && _params$search !== void 0 ? _params$search : '', toPagination(params), {
      includeOutdatedOnly: params.includeOutdatedOnly === true,
      tags: requestTags
    });
    return _sloSchema.findSloDefinitionsResponseSchema.encode(result);
  }
}
exports.FindSLODefinitions = FindSLODefinitions;
function toPagination(params) {
  const page = Number(params.page);
  const perPage = Number(params.perPage);
  if (!isNaN(perPage) && perPage > MAX_PER_PAGE) {
    throw new _errors.IllegalArgumentError(`perPage limit set to ${MAX_PER_PAGE}`);
  }
  return {
    page: !isNaN(page) && page >= 1 ? page : DEFAULT_PAGE,
    perPage: !isNaN(perPage) && perPage >= 1 ? perPage : DEFAULT_PER_PAGE
  };
}