"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createBurnRatePanelAction = createBurnRatePanelAction;
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/observability-shared-plugin/common");
var _presentationContainers = require("@kbn/presentation-containers");
var _public = require("@kbn/ui-actions-plugin/public");
var _constants = require("../embeddable/slo/burn_rate/constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function createBurnRatePanelAction(coreStart, pluginsStart, sloClient) {
  return {
    id: _constants.ADD_BURN_RATE_ACTION_ID,
    grouping: _common.COMMON_OBSERVABILITY_GROUPING,
    order: 20,
    getIconType: () => 'visGauge',
    isCompatible: async ({
      embeddable
    }) => {
      return (0, _presentationContainers.apiIsPresentationContainer)(embeddable);
    },
    execute: async ({
      embeddable
    }) => {
      if (!(0, _presentationContainers.apiIsPresentationContainer)(embeddable)) throw new _public.IncompatibleActionError();
      try {
        const {
          openConfiguration
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('../embeddable/slo/burn_rate/open_configuration')));
        const initialState = await openConfiguration(coreStart, pluginsStart, sloClient);
        embeddable.addNewPanel({
          panelType: _constants.SLO_BURN_RATE_EMBEDDABLE_ID,
          serializedState: {
            rawState: initialState
          }
        }, true);
      } catch (e) {
        return Promise.reject();
      }
    },
    getDisplayName: () => _i18n.i18n.translate('xpack.slo.burnRateEmbeddable.ariaLabel', {
      defaultMessage: 'SLO Burn Rate'
    })
  };
}